<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Customer;
use File;
use Auth;
use DB;
use Illuminate\Http\Response;
use Yajra\Datatables\Datatables;
class CustomerController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    private $data = array(
        'route' => 'admin.customer.',
        'title' => 'Customer',
        'menu' => 'Customer',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
            $customerSearch = $request->search['value'];
            $records = Customer::orderBy('id','DESC')
                                ->when($request->startDate, function ($query) use ($request) {
                                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                    if ($request->endDate) {
                                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                        return $query->whereBetween('customers.created_at', [$startDate, $endDate]);
                                    }
                                    return $query->where('customers.created_at', '>=', $startDate);
                                })
                                ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                    return $query->where('customers.created_at', '<=', $endDate);
                                })
                                ->when($customerSearch, function ($query) use ($customerSearch) {
                                    return $query->where(function ($q) use ($customerSearch) {
                                                $q->where('first_name', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('last_name', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('state', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('email', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('pincode', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('mobile', 'like', '%' . $customerSearch . '%');
                                            });
                                });
             $sr = 1;
             return Datatables::of($records)
             ->addIndexColumn()
             ->addColumn('sr_no', function ($record) use (&$sr) {
                 return $sr++;
             })
             ->addColumn('email_phone', function ($record) {
                $div = "<div class='text-left'>";
                $div .= "<b>Phone Number:-</b> ".$record->mobile."<br><b>Email:-</b> ".$record->email;
                $div .="</div>";
                return $div;   
            })
             ->editColumn('image_name',function ($record){
                $image =  '<img src="'.url('/assets/admin/images/user.png').'" alt="image" class="img-thumbnail mx-3 rounded-circle" width="80px" height="80px " >';
                $image.= $record->first_name.' '.$record->last_name;
                 return $image;
             })
             ->editColumn('created_at', function ($record) {
                return $record->created_at->format('d-m-Y H:m a');
            })
             ->editColumn('status', function ($record) {
                 return '<div class="form-check form-switch d-flex justify-content-end">
                         <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
             })
          
             ->addColumn('action', function ($record) {
                 return '<a class="btn btn-sm btn-primary customerView text-white" data-id="'.$record->id.'" ><i class="fe fe-eye"></i></a> '.
                       '&nbsp;<a href="'.url('admin/customer/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                       '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
             })
             ->rawColumns(['status','action','sr_no','image_name','email_phone'])
             ->make(true);
     }
    
    
    
            return view('admin.customer.index',$this->data);
        
    }

   
    public function create()
    {
		$customer = [];
        return view('admin.customer.create')->with(['customer'=>$customer]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'first_name' => 'required',
            'last_name' => 'required',
            'mobile' => 'required|numeric|digits:10|unique:customers,mobile',
			'email' => 'required|email|unique:customers,email',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		$input = $request->all();
        $admin = new Customer($input);
        $admin->save();
        return redirect('admin/customer')->withSuccess('Added successfully');
       
    }

    public function show($id)
    {
		$customer = Customer::find($id);
        return view('admin.customer.show')->with(['customer'=>$customer]);
    }

    public function customerView(Request $request){
        $customer = Customer::find($request->id);
        $data = [
            'customer' => $customer,
        ];
        return response()->json([
            'success' => true,
            'html' => view('admin.customer.customerView', $data)->render()
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$customer = Customer::find($id);
		
        return view('admin.customer.create',['customer'=>$customer]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$customer = Customer::find($id);
	
        if ($request->ajax()) {
        if(!empty($request->currentStatus)){
            if($request->currentStatus == 'Active'){
                $customer->status = 'Deactive';
            }else{
                $customer->status = 'Active';
            }		  
        }
        $customer->save();
        $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
        }
       $sValidationRules =  [
                                'first_name' => 'required',
                                'last_name' => 'required',
                                'mobile' => 'required|numeric|digits:10|unique:customers,mobile,'.$id.',id',
                                'email' => 'required|email|unique:customers,email,'.$id.',id',
                            ];
       
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
     
        $customer->update($input);
        return redirect('admin/customer')->withSuccess('Update successfully');
    }

 
    public function destroy(Request $request)
    {
        $admin = Customer::find($request->id);
        if (\File::exists(public_path($admin['image']))) {
            \File::delete(public_path($admin['image']));
        } 
        Customer::where('id', '=', $request->id)->delete();
        return redirect(route('admin.customer'))->withSuccess('Deleted successfully');
    }
	
	 public function customerdelete($id)
    {
      
        Customer::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
}
