<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Admin;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class EmployeeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.employee.',
        'title' => 'Employee',
        'menu' => 'Employee',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
               
            $records = Admin::where('Is_employee',1)->orderBy('id','DESC');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
               
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" style="margin-left:10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })

               

                
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/employee/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                          '&nbsp;<a href="'.url('admin/employee/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','sr_no'])
                ->make(true);
        }
        $this->data['status'] = $request->status;
       
        return view('admin.employee.index',$this->data);
    
    }

   
    public function create()
    {
		$employee = [];
        return view('admin.employee.create')->with(['employee'=>$employee]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'name' => 'required',
            'email' =>'required|email|unique:admins,email',
            'password'=>'required|min:6',
            'mobile'=>'required|numeric|digits:10',
            'alt_mobile'=>'required|numeric|digits:10',
            'confirm_password' =>'required|same:password',
            'profile_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
            'aadhar_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
            'cancelled_chaque_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
            'certificate_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
            'appointment_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		$input = $request->all();

		$admin = New Admin($input);
        $admin->Is_employee = 1;
        $admin->password = bcrypt($request->password);
		$admin->date_of_birth = date('Y-m-d',strtotime($request->date_of_birth));
        $admin->date_of_joining = date('Y-m-d',strtotime($request->date_of_joining));
       
          if($request->hasFile('profile_image')){
            $image = rand().time().'.'.$request->profile_image->extension();
            $request->profile_image->move(public_path('uploads/employee'), $image);
            $admin->profile_image = 'uploads/employee/'.$image;
        } 
        
        if($request->hasFile('aadhar_image')){
            $image = rand().time().'.'.$request->aadhar_image->extension();
            $request->aadhar_image->move(public_path('uploads/employee'), $image);
            $admin->aadhar_image = 'uploads/employee/'.$image;
        } 

        if($request->hasFile('cancelled_chaque_image')){
            $image = rand().time().'.'.$request->cancelled_chaque_image->extension();
            $request->cancelled_chaque_image->move(public_path('uploads/employee'), $image);
            $admin->cancelled_chaque_image = 'uploads/employee/'.$image;
        } 

        if($request->hasFile('certificate_image')){
            $image = rand().time().'.'.$request->certificate_image->extension();
            $request->certificate_image->move(public_path('uploads/employee'), $image);
            $admin->certificate_image = 'uploads/employee/'.$image;
        } 

        if($request->hasFile('appointment_image')){
            $image = rand().time().'.'.$request->appointment_image->extension();
            $request->appointment_image->move(public_path('uploads/employee'), $image);
            $admin->appointment_image = 'uploads/employee/'.$image;
        } 
        
        $admin->save();
		
        return redirect('admin/employee')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$employee = Admin::find($id);
        return view('admin.employee.show')->with(['employee'=>$employee]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$employee = Admin::find($id);
		
        return view('admin.employee.create',['employee'=>$employee]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$employee = Admin::find($id);
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $employee->status = 'Deactive';
		  }	
          else{
			  $employee->status = 'Active';
		  }		  
		}
		  $employee->save();
          $response['message'] = 'Status Updated Successfully.';
          $response['result'] = '1';
		  return $response;
		
			 
		 }
         $sValidationRules = [
            'name' => 'required',
            'email' =>'required|email|unique:admins,email'.','.$id,
            'password'=>'nullable|min:6',
            'mobile'=>'required|numeric|digits:10',
            'alt_mobile'=>'required|numeric|digits:10',
            'confirm_password' =>'nullable|same:password',
            'profile_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
            'aadhar_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
            'cancelled_chaque_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
            'certificate_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
            'appointment_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
	
      if($request->hasFile('profile_image')){
            if(file_exists(asset($employee->profile_image))){
                unlink(asset($employee->profile_image));
            }
            $image = rand().time().'.'.$request->profile_image->extension();
            $request->profile_image->move(public_path('uploads/employee'), $image);
            $input['profile_image'] = 'uploads/employee/'.$image;
        } 
       
        
      if($request->hasFile('aadhar_image')){
        if(file_exists(asset($employee->aadhar_image))){
            unlink(asset($employee->aadhar_image));
        }
        $image = rand().time().'.'.$request->aadhar_image->extension();
        $request->aadhar_image->move(public_path('uploads/employee'), $image);
        $input['aadhar_image'] = 'uploads/employee/'.$image;
    } 
    
       
    if($request->hasFile('cancelled_chaque_image')){
        if(file_exists(asset($employee->cancelled_chaque_image))){
            unlink(asset($employee->cancelled_chaque_image));
        }
        $image = rand().time().'.'.$request->cancelled_chaque_image->extension();
        $request->cancelled_chaque_image->move(public_path('uploads/employee'), $image);
        $input['cancelled_chaque_image'] = 'uploads/employee/'.$image;
    } 

    if($request->hasFile('certificate_image')){
        if(file_exists(asset($employee->certificate_image))){
            unlink(asset($employee->certificate_image));
        }
        $image = rand().time().'.'.$request->certificate_image->extension();
        $request->certificate_image->move(public_path('uploads/employee'), $image);
        $input['certificate_image'] = 'uploads/employee/'.$image;
    } 

    if($request->hasFile('appointment_image')){
        if(file_exists(asset($employee->appointment_image))){
            unlink(asset($employee->appointment_image));
        }
        $image = rand().time().'.'.$request->appointment_image->extension();
        $request->appointment_image->move(public_path('uploads/employee'), $image);
        $input['appointment_image'] = 'uploads/employee/'.$image;
    } 
    $input['date_of_birth'] = date('Y-m-d',strtotime($request->date_of_birth));
    $input['date_of_joining'] = date('Y-m-d',strtotime($request->date_of_joining));
    if(empty($request->password))
    {
        unset($input['password']);
    }else{
        $input['password'] = bcrypt($request->password);
    }

        $employee->update($input);
        return redirect('admin/employee')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Admin::find($request->id);
        if (File::exists(public_path($admin['profile_image']))) {
            File::delete(public_path($admin['profile_image']));
        } 
        if (File::exists(public_path($admin['aadhar_image']))) {
            File::delete(public_path($admin['aadhar_image']));
        } 
        if (File::exists(public_path($admin['cancelled_chaque_image']))) {
            File::delete(public_path($admin['cancelled_chaque_image']));
        } 
        if (File::exists(public_path($admin['certificate_image']))) {
            File::delete(public_path($admin['certificate_image']));
        } 
        if (File::exists(public_path($admin['appointment_image']))) {
            File::delete(public_path($admin['appointment_image']));
        } 

        Admin::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	
}
