<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Gallery;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class ClientGalleryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.clientgallery.',
        'title' => 'Client Gallery',
        'menu' => 'Client',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
               
            $records = ClientGallery::orderBy('id','DESC');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
               
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" style="margin-left:10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })

                ->addColumn('image', function ($record) {

					if(!empty($record['image_url'])){

						return '<a href= "'. url($record->image_url).'" target="_blank" >View</a>';

					}else{

						return '';

					}

				})

                
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/gallery/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                          '&nbsp;<a href="'.url('admin/gallery/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','sr_no','image'])
                ->make(true);
        }
        $this->data['status'] = $request->status;
       
        return view('admin.clientgallery.index',$this->data);
    
    }

   
    public function create()
    {
		$gallery = [];
        return view('admin.clientgallery.create')->with(['gallery'=>$gallery]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
          
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:8048',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect(route('admin.clientgallery.index'))->withErrors($validator)->withInput();
        }  
		

		$admin = New ClientGallery;
		

          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/gallery'), $image);
            $admin->image = 'uploads/gallery/'.$image;
        } 
        
        $admin->save();
		
        return redirect('admin/clientgallery')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$gallery = ClientGallery::find($id);
        return view('admin.clientgallery.show')->with(['gallery'=>$gallery]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$gallery = ClientGallery::find($id);
		
        return view('admin.clientgallery.create',['gallery'=>$gallery]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$gallery = ClientGallery::find($id);
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $gallery->status = 'Deactive';
		  }	
          else{
			  $gallery->status = 'Active';
		  }		  
		}
		  $gallery->save();
          $response['message'] = 'Status Updated Successfully.';
          $response['result'] = '1';
		  return $response;
		
			 
		 }
        $sValidationRules = [
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		
		
        
		
      
     
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($gallery->image))){
                unlink(asset($gallery->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/gallery'), $image);
            $input['image'] = 'uploads/gallery/'.$image;
        } 
        $gallery->update($input);
        return redirect('admin/clientgallery')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = ClientGallery::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        ClientGallery::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	
}
