<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Media;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class MediaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.media.',
        'title' => 'Media',
        'menu' => 'Media',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
            $records = Media::orderBy('id','DESC');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })

                ->editColumn('link', function ($record) {
                    return '<a href="' . e($record->link) . '" target="_blank" style="color:blue; text-decoration:none;">
                                View
                            </a>';
                })  
                
                ->editColumn('description', function ($record) {
                    return strip_tags($record->description);
                })
               
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" style="margin-left:10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/media/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','sr_no','image', 'link', 'description'])
                ->make(true);
        }
        $this->data['status'] = $request->status;
       
        return view('admin.media.index',$this->data);
    }

   
    public function create()
    {
		$media = [];
        return view('admin.media.create')->with(['media'=>$media]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'link' => [
                'required',
                'regex:/^https?:\/\/[^\s]+$/i'
            ],
            'description' => 'required',
        ];             
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }        
		$admin = New Media;
		$admin->link = $request->link;
		$admin->description = $request->description;
        $admin->save();
		
        return redirect('admin/media')->withSuccess('Added successfully');
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$media = Media::find($id);
		
        return view('admin.media.create',['media'=>$media]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$media = Media::find($id);
	
		if ($request->ajax()) {
            if(!empty($request->currentStatus)){
                if($request->currentStatus == 'Active'){
                    $media->status = 'Deactive';
                }else{
                    $media->status = 'Active';
                }		  
            }
            $media->save();
            $response['message'] = 'Status Updated Successfully.';
            $response['result'] = '1';
            return $response;
		}
        $sValidationRules = [
            'link' => [
                'required',
                'regex:/^https?:\/\/[^\s]+$/i'
            ],
            'description' => 'required',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }        
        $media->update($input);
        return redirect('admin/media')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Media::find($request->id);
        Media::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	
}
