<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Order;
use App\Models\Customer;
use App\Models\Admin;
use App\Models\Phonenumber;
use App\Models\Orderdetail;
use App\Models\Payment;
use App\Models\VendorAccount;
use App\Models\Sitesetting;
use App\Models\User;
use Yajra\Datatables\Datatables;
use DB;
use Carbon\Carbon;
class OrderController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    public function index(Request $request)
    {   
       
            if ($request->ajax()) {
                $orderDetailSearch = $request->search['value'];
                $records = Order::with(['customer', 'orderdetails', 'employee'])->select('orders.*')
                                ->when($request->status && $request->status != 'all', function ($query) use ($request) {
                                    return $query->where('orders.order_status', $request->status);
                                })
                                ->when($request->startDate, function ($query) use ($request) {
                                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                    if ($request->endDate) {
                                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                        return $query->whereBetween('orders.order_date', [$startDate, $endDate]);
                                    }
                                    return $query->where('orders.order_date', '>=', $startDate);
                                })
                                ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                    return $query->where('orders.order_date', '<=', $endDate);
                                })
                                ->when($orderDetailSearch, function ($query) use ($orderDetailSearch) {
                                    return $query->where(function ($q) use ($orderDetailSearch) {
                                                $Orderdetail = Orderdetail::where('product_name',$orderDetailSearch)->first();
                                                $employee = Admin::where('name',$orderDetailSearch)->first();
                                                if (!empty($Orderdetail) || !empty($employee)) {
                                                    $q->where(function ($q) use ($Orderdetail, $employee) {
                                                        if (!empty($Orderdetail)) {
                                                            $q->where('orders.id', $Orderdetail->order_id ?? 0);
                                                        }
                                                        if (!empty($employee)) {
                                                            $q->orWhere('orders.assign_to', $employee->id ?? 0);
                                                        }
                                                    });
                                                } else {
                                                    $q->where(function ($q) use ($orderDetailSearch) {
                                                        $q->whereRaw("REPLACE(orders.mobile_no, ' ', '') LIKE ?", ['%' . $orderDetailSearch . '%'])
                                                            ->orWhere('orders.mobile_no', 'like', '%' . $orderDetailSearch . '%')
                                                            ->orWhere('orders.name', 'like', '%' . $orderDetailSearch . '%')
                                                            ->orWhere('orders.payment_status', 'like', '%' . $orderDetailSearch . '%')
                                                            ->orWhere('orders.order_status', 'like', '%' . str_replace(' ', '_', $orderDetailSearch). '%')
                                                            ->orWhere('orders.order_number', $orderDetailSearch)
                                                            ->orWhere('orders.order_total', $orderDetailSearch);
                                                    });
                                                }
                                                    
                                            });
                                })
                                ->select('orders.*')
                                ->orderBy('updated_at', 'DESC')->distinct();
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->addColumn('purchase_details', function ($record) {
                       /* return '<a onclick="window.open(`order/'.$record->id.'/edit`, `_blank`, `height=600, width=1000, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no`);"  href="#">Purchase Detail</a>';*/
                        return '<a onclick="openPurchasePopup(event, \'order/'.$record->id.'/edit\');" href="#">Purchase Detail</a>';
                    })
                    
                    ->addColumn('customer',function ($record) {
                        /*$cus_name = $record->name;
                        return '<a onclick="window.open(\''.url('admin/customer',$record->customer_id).'\', \'_blank\', \'height=600, width=800, left=150, top=150, titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no\');" href="#">'.$cus_name.'</a>';*/
                        $cus_name = $record->name;
                        return '<a onclick="openCustomerPopup(event, \''.url('admin/customer', $record->customer_id).'\');" href="#">'.$cus_name.'</a>';
                    })
                    ->addColumn('email', function ($record) {    
                        $cus_name = $record->customer->email??'';
                        return $cus_name;
                    })
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format('d-m-Y H:i a');
                    })

                    ->editColumn('updated_at', function ($record) {
                        return $record->updated_at->format('d-m-Y H:i a');
                    })

                    ->editColumn('order_total', function ($record) {
                        return round($record->order_total);
                    })

                    ->editColumn('order_status', function ($record) {
                        $order_status = str_replace('_', ' ', $record->order_status);
                        $order_status = ucfirst($order_status);
                        return $order_status;
                    })
                    ->addColumn('action', function ($record) {
                     
                        $button = '<button class="btn btn-sm btn-primary data-edit" onclick="window.open(`orderactivity/'.$record->id.'`, `_blank`, `height=500, width=800, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no`);" data-id="'.$record->id.'" title=""><i class="fe fe-edit"></i></button>';

                            $invoiceIcon = '';
                            if ($record->payment_status == 'Paid') {
                                $invoiceIcon = '<a href="'.url('admin/orderinvoice', $record->id).'" style="margin-left: 7px;" target="blank"><i class="fas fa-file"></i></a>';
                            }

                            $paymentFormIcon = '<a href="'.url('admin/paymentForm', $record->id).'" class=""><i class="fa fa-credit-card"></i></a>';
                            return $button . ' ' . $invoiceIcon . ' <br>' . $paymentFormIcon;
                      
                    })
                   
                    ->rawColumns(['status','action','customer','sr_no','purchase_details','email']) 
                    ->make(true);
            }
            $this->data['status'] = $request->status;
            return view('admin.order.index',$this->data);
        
    }

   
    public function create()   
    {
		$numbers = null;
        $employees = Admin::where('Is_employee',1)->get();
        return view('admin.order.create')->with(['numbers'=>$numbers,'employees'=>$employees]);
    }

   
    public function store(Request $request)
    {
		
        // dd($request->gst_status);
        /*$sValidationRules = [
            'customer_id' => 'required',
			'assign_to' => 'required',
            'activation_date' => 'required',
            'numbers' => 'required',
            'shipping_charge' => 'required',
            'gst_status' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())
        {
            return redirect('admin/order/create')->withErrors($validator)->withInput();
        }  
        $numberWithoutSpaces = str_replace(' ', '', $request->numbers);
		$numbers = preg_replace('/[^0-9]/', '', $numberWithoutSpaces);*/


        $validate_all_number = Phonenumber::whereIn('id',$request->numbers)->get();

        foreach($validate_all_number as $val)
        {
            if($val->status != 'Available')
            {
                return redirect('admin/order/create')->with('error', 'Number is inactive');
            }
    
        }
        
            $order_id = Order::orderBy('id','DESC')->first();
            if($order_id){
                $id = $order_id->id+1;
            }else{
                $id = 1;
            }
            $formatted_number = str_pad($id, 5, "0", STR_PAD_LEFT);
          
            $order = new Order();
            $order->order_number = $formatted_number;
            $order->customer_id = $request->customer_id;
            $order->assign_to = $request->assign_to;
            $order->activation_date = $request->activation_date;
            $customer = Customer::where('id',$request->customer_id)->first();
            $order->name = $customer->first_name.' '.$customer->last_name;
            $order->mobile_no = $customer->mobile;
            $order->shipping_charge = $request->shipping_charge;
            $order->payment_status = 'pending';
            $order->order_status = 'new';
            $order->gst_status = $request->gst_status;
            $order->order_date = date('Y-m-d H:m:s');
            $order->entri_type = 'admin';
            $order->employee_name = auth()->user()->name??'';
            $order->save();
            foreach($request->numbers as $number_id){
                $number = Phonenumber::where('id',$number_id)->first();
                $orderdetail = new Orderdetail();
                $orderdetail->order_number = $formatted_number;
                $orderdetail->vendor_id = $number->vendor_id;
                $orderdetail->product_id = $number->id;
                $orderdetail->order_id = $order->id;
                $orderdetail->product_name = $number->actual_number;
                $orderdetail->order_date = date('Y-m-d H:m:s');
                $orderdetail->number_rate = $number->number_rate;
                $orderdetail->vendor_rate = $number->vendor_rate;
                $orderdetail->discount = $number->discount;
                if($number->discount != '0'){
                    $discount_price = $number->number_rate*$number->discount/100;
                    $rate = $number->number_rate-$discount_price;
                }else{
                    $rate = $number->number_rate;
                }
                $orderdetail->discount_rate = $rate;
                $orderdetail->upc_no = 'Unique Porting Code for your mobile number '.$number->actual_number.' is XXXX, Your UPC will be valid till XXXX . Please do not disclose these details to anyone except the authorized personnel of operator where you wish to port. Thanks And Reg Golden Telecom';
                $orderdetail->save();
            }
            $order_sum = Orderdetail::where('order_id',$order->id)->sum('discount_rate');
            $gst_amount = '';
                if($request->gst_status == 'Yes'){
                    $gst_amount =  $order_sum*18/100;
                    $order->gst_amount = $gst_amount;
                }else{
                    $gst_amount = 0;
                    $order->gst_amount = $gst_amount;
                }
            $order->order_total = round($order_sum + $gst_amount);
            $order->gst_amount = $gst_amount;
            $order->update();

            if($request->sms_to_customer == "YES"){

          
                $vanity_number = Orderdetail::where('order_id',$order->id)->pluck('product_name')->toArray();
                $vanity = implode(',',$vanity_number);
            
            
                $custName = $customer->first_name;
                
                $sms = "Dear ".$custName.", Thank you for choosing us. Your Vanity Number ".$vanity." has been booked through online transaction of Rs.".$order->order_total." Our executive will get in touch with you shortly. And Provide Upc Within 24 Hours Regards Team lifetimenumber.com Golden Telecom.";  
            
            
                $Number = $customer->mobile;
                $sms2=urlencode($sms);
                $sms_url ="http://www.smsjust.com/blank/sms/user/urlsms.php?username=nitin12345&pass=Nitin@1234&senderid=Goldno&dest_mobileno=$Number&message=$sms2&response=Y";

                $ch=curl_init();
                curl_setopt($ch,CURLOPT_URL,$sms_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
                curl_setopt($ch,CURLOPT_TIMEOUT, '3');
                $content = trim(curl_exec($ch));
                curl_close($ch);

            }
            
            return redirect()->route('admin.payment', ['id' => $order->id])->with('success', 'Added successfully');
           
        
        
      
        
    }

    public function show($id)
    {
		$number = Order::find($id);
        
        return view('admin.phonenumber.show')->with(['number'=>$number]);
    }

 
    public function edit($id)
    {
        
		$order = Order::find($id);
        $orderdetail = Orderdetail::where('order_id',$id)->get();
        return view('admin.order.edit',['order'=>$order,'orderdetail'=>$orderdetail]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$vendor = Order::find($id);
       
		 if ($request->ajax()) {
			 
            if(!empty($request->currentStatus))
            {
                if($request->currentStatus == 'Active')
                {
                    $vendor->status = 'Deactive';
                }	
                else{
                    $vendor->status = 'Active';
                }		  
            }
		  $vendor->save();
		  return 1;
		
			 
		 }
         $sValidationRules = [
            'category_id' => 'required',
			'vendor_id' => 'required',
            'number' => 'required',
            'highlight_number' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/order/create')->withErrors($validator)->withInput();
        }  
        $vendor->update($input);
        return redirect('admin/phone')->withSuccess('Update successfully');
    }

  
    public function destroy(Request $request)
    {
      
        Order::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }

    public function getcustomer_search(Request $request)
    {
        $term = trim($request->q);

        if (empty($term)) {
            $tags = Customer::limit(50)->orderBy('id','DESC')->get();

            foreach ($tags as $tag) {
                $formatted_tags[] = ['id' => $tag->id,'text' => $tag->first_name.' '.$tag->first_name. '   '. $tag->mobile . '   ' .$tag->email] ;
            }    
            return response()->json($formatted_tags);
        }


        $tags = Customer::where('name', 'LIKE', $term . '%')->orWhere('name', 'LIKE', '%' . $term . '%')->orwhere('email', 'LIKE', '%' . $term . '%')->orwhere('mobile', 'LIKE', '%' . $term . '%')->orderByRaw("CASE WHEN name LIKE '$term%' THEN 1 ELSE 2 END")->limit(50)->orderBy('id','DESC')->get();

        foreach ($tags as $tag) {
            $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->first_name.' '.$tag->first_name.'   '. $tag->mobile . '   ' .$tag->email ];
        }

        $formatted_tags =!empty($formatted_tags) ?array_values($formatted_tags):[];


        return response()->json($formatted_tags);
    }

    public function customerCheck(Request $request){
        $data = $request->formdata;
        parse_str($data, $formData);
        $customer = Customer::where('mobile',$formData['mobile'])->first();
        if($customer){
            $response['message'] = 'Customer already exist';
            $response['success'] = false;
            return response()->json($response);
        }else{
            $customer = new Customer();
            $customer->first_name = $formData['first_name'];
            $customer->mobile = $formData['mobile'];
            $customer->email = $formData['email'];
            $customer->pincode = $formData['pincode'];
            $customer->address = $formData['address'];
            $customer->state = $formData['state'];
            $customer->customer_type = $formData['customer_type'];
            $customer->company_name = $formData['company_name']??null;
            $customer->gst_number = $formData['gst_number']??null;
            $customer->save();
            $response['message'] = 'Customer add successfully';
            $response['customer'] = '<option value="'.$customer->id.'" selected>'.$customer->name.' '.$customer->mobile.' '.$customer->email.'</option>';
            $response['success'] = true;
            return response()->json($response);
        }
    }

    public function numberssearch(Request $request){
        $term = trim($request->q);
        if (empty($term)) {
            $tags = Phonenumber::limit(50)->where('status','Available')->get();

            foreach ($tags as $tag) {
                $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->actual_number] ;
            }    
            return response()->json($formatted_tags);
        }

        $tags = Phonenumber::where('actual_number', 'LIKE', $term . '%')->where('status','Available')->limit(50)->get();

        foreach ($tags as $tag) {
            $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->actual_number];
        }

        $formatted_tags =!empty($formatted_tags) ?array_values($formatted_tags):[];


        return response()->json($formatted_tags);
    }
	
	public function payment($id)
    {   
        $order = Order::where('id',$id)->first();
        return view('admin.order.payment')->with(['order'=>$order]);
    }


    public function paymentstore(Request $request)
    {


        $number_pluck =Orderdetail::where('order_id',$request->order_id)->pluck('product_id')->toArray();

        $validate_all_number = Phonenumber::whereIn('id',$number_pluck)->get();

        foreach($validate_all_number as $val){
            if($val->status != 'Available')
            {
                return redirect('admin/order')->with('error', 'Number is inactive');
            }
    
        }
       
        $sValidationRules = [
            'payment_type' => 'required',
            'amount' => 'required',
            'payment_mode' => 'required',
            'approval_sms' => 'required',
            // 'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:5120',
        ];


        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $order_date = Order::where('id',$request->order_id)->first();
	  
        $input = $request->all();
        $payment = Payment::where('merchantTxnd',$request->txn_id)->first();
        if(empty($payment)){
            $input['order_id'] = $request->order_id;
            $input['customer_id'] = $order_date->customer_id;
            $input['order_number'] = $request->order_number;
            if($request->hasFile('image')){
                $image = rand().time().'.'.$request->image->extension();
                $request->image->move(public_path('uploads/payment'), $image);
                $input['image'] = 'uploads/payment/'.$image;
            } 
            $record = new Payment($input);
            $record->save();
        }   

        $order_date->payment_status = 'Paid';

        $sitesetting = Sitesetting::first();
            $user = User::find($order_date->customer_id);
           
            if($user->customer_type == 'Corporate'){
                $order_no = $sitesetting->invoice_nogst;
                $in_no = (int)$order_no + 1;
                $formatted_invoice= str_pad($in_no, 5, "0", STR_PAD_LEFT);
                $invoice_no = $sitesetting->gst_invoice_perameter.$sitesetting->invoice_year.$formatted_invoice;

                $sitesetting->invoice_nogst =  $in_no;
                $sitesetting->update();
            
            }else{
                $order_no = $sitesetting->invoice_no;
                $in_no = (int)$order_no + 1;
                $formatted_invoice= str_pad($in_no, 5, "0", STR_PAD_LEFT);
                $invoice_no = $sitesetting->without_gst_invoice_perameter.$sitesetting->invoice_year.$formatted_invoice;
                $sitesetting->invoice_no =  $in_no;
                $sitesetting->update();
            }
            
            $formatted_invoice= str_pad($invoice_no, 5, "0", STR_PAD_LEFT);

        $order_date->invoice_no = $formatted_invoice;
        $order_date->update();

        $orders = Orderdetail::where('order_id',$request->order_id)->get();
        if($request->payment_type == 'New'){
            foreach($orders as $orderdetail){
                $number = Phonenumber::where('actual_number',$orderdetail->product_name)->first();
                $number->status = 'Sold';
                $number->save();
            }
        }  
       


        $vanity_number = Orderdetail::where('order_id',$request->order_id)->pluck('product_name')->toArray();
        $vanity = implode(',',$vanity_number);
        $customer = Customer::where('id',$order_date->customer_id)->first();
        $Number = $customer->mobile;
        if($request->approval_sms == 'YES'){
            $sms = "Your Vanity Number ".$vanity." has been booked through online transaction of Rs. ".$request->amount." Order ID is ".$request->order_number." Golden Telecom
            ";  

            $sms2=urlencode($sms);
            $sms_url ="http://www.smsjust.com/blank/sms/user/urlsms.php?username=nitin12345&pass=Nitin@1234&senderid=Goldno&dest_mobileno=$Number&message=$sms2&response=Y";

            $ch=curl_init();
            curl_setopt($ch,CURLOPT_URL,$sms_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
            curl_setopt($ch,CURLOPT_TIMEOUT, '3');
            $content = trim(curl_exec($ch));
            curl_close($ch);
        }


        return redirect('admin/order?status=all')->withSuccess('Payment successfully');
    }


    public function update_order_detail_status(Request $request)
    {

        $order_detail = Orderdetail::where('id', $request->id)->first();
        // dd($order_detail);    
        $order_detail->status = $request->status;
        $order_detail->save();


        if($request->status == 'UPC Delivered' || $request->status == 'Activation In Process')
        {
            // $vendoraccount = VendorAccount::where('order_id',$order_detail->order_id)->where('product_id',$order_detail->product_id)->first();
            // $vendoraccount->payment_elegible = 'Y';
            // $vendoraccount->save();
            //    $check_vendoraccount = VendorAccount::where('vendor_id',$order_detail->vendor_id)
            //                                     ->where('order_id',$order_detail->order_id)
            //                                     ->where('product_id',$order_detail->product_id)
            //                                     ->first();
            $check_vendoraccount = VendorAccount::withTrashed()->where('product_id',$order_detail->product_id)
                                            ->first();
            if(empty($check_vendoraccount)){
               
                $payment = Payment::where('order_id', $order_detail->order_id)->first();
                $venderaccount = new VendorAccount();
                $venderaccount->vendor_id = $order_detail->vendor_id;
                $venderaccount->order_id = $order_detail->order_id;
                $venderaccount->product_id = $order_detail->product_id;
                $venderaccount->payment_elegible = 'Y';
                $venderaccount->payment_status = 'N';
                $venderaccount->order_date = $order_detail->created_at;
                $venderaccount->order_pay_date = $payment->created_at??null;
                $venderaccount->save();
            }else{
                $check_vendoraccount->restore();
                $payment = Payment::where('order_id', $order_detail->order_id)->first();
                $check_vendoraccount->vendor_id = $order_detail->vendor_id;
                $check_vendoraccount->order_id = $order_detail->order_id;
                $check_vendoraccount->product_id = $order_detail->product_id;
                $check_vendoraccount->payment_elegible = 'Y';
                $check_vendoraccount->payment_status = 'N';
                $check_vendoraccount->order_date = $order_detail->created_at;
                $check_vendoraccount->order_pay_date = $payment->created_at??null;
                $check_vendoraccount->update();
            }
        }

        if($request->status == 'Activated'){
            $vendoraccount_status_update = VendorAccount::where('vendor_id',$order_detail->vendor_id)
                                                    ->where('order_id',$order_detail->order_id)
                                                    ->where('product_id',$order_detail->product_id)
                                                    // ->where('payment_elegible','Y')
                                                    ->first();
            if(!empty($vendoraccount_status_update)){
                $vendoraccount_status_update->payment_elegible = 'Y';
                $vendoraccount_status_update->update();
            }
        }

        if($request->status == 'Not Contacted' || $request->status == 'To Be Refund' || $request->status == 'Refund' || $request->status == 'Test'|| $request->status == 'Cancelled'){
            $vendoraccount_status_update = VendorAccount::where('vendor_id',$order_detail->vendor_id)
                                                    ->where('order_id',$order_detail->order_id)
                                                    ->where('product_id',$order_detail->product_id)
                                                    // ->where('payment_elegible','Y')
                                                    ->first();
            // dd($vendoraccount_status_update);    
            if(!empty($vendoraccount_status_update)){
                $vendoraccount_status_update->payment_elegible = 'C';
                $vendoraccount_status_update->payment_status = 'C';
                $vendoraccount_status_update->update();
            }
        }

        return 'Status Updated'; 
    }
    public function upcorderdetail($id)       
    {
       $orderdetail = Orderdetail::find($id);
       return view('admin.order.upcedit')->with(['id'=>$id,'orderdetail'=>$orderdetail]);
    }
    public function upcedit(Request $request,$id)
    {
      
        $orderdetail = Orderdetail::where('id',$id)->first();
        $orderdetail->upc_no = $request->upc_no;
        
        $orderdetail->status = 'UPC Delivered'; 
        $orderdetail->update();
        
        $order = Order::where('id',$orderdetail->order_id)->first();
        // print_r($order);exit;
        $customer = Customer::where('id',$order->customer_id)->first();
        $Number = $customer->mobile;
        // print_r($Number);exit;
        $custName = $customer->first_name.' '.$customer->last_name;
        $sms = $request->upc_no;  

        $sms2=urlencode($sms);
        $sms_url ="http://www.smsjust.com/blank/sms/user/urlsms.php?username=nitin12345&pass=Nitin@1234&senderid=Goldno&dest_mobileno=$Number&message=$sms2&response=Y";

        $ch=curl_init();
        curl_setopt($ch,CURLOPT_URL,$sms_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch,CURLOPT_TIMEOUT, '3');
        $content = trim(curl_exec($ch));
        curl_close($ch);
      
        // $check_vendoraccount = VendorAccount::where('vendor_id',$orderdetail->vendor_id)
        //                                     ->where('order_id',$orderdetail->order_id)
        //                                     ->where('product_id',$orderdetail->product_id)
        //                                     ->first();
      
        $check_vendoraccount = VendorAccount::where('product_id',$orderdetail->product_id)->first();
            if(empty($check_vendoraccount)){
                $payment = Payment::where('order_id', $orderdetail->order_id)->first();
                $venderaccount = new VendorAccount();
                $venderaccount->vendor_id = $orderdetail->vendor_id;
                $venderaccount->order_id = $orderdetail->order_id;
                $venderaccount->product_id = $orderdetail->product_id;
                $venderaccount->payment_elegible = 'Y';
                $venderaccount->payment_status = 'N';
                $venderaccount->order_date = $orderdetail->created_at;
                $venderaccount->order_pay_date = $payment->created_at??null;
                $venderaccount->save();
            }else{
                $check_vendoraccount->restore();
                $payment = Payment::where('order_id', $orderdetail->order_id)->first();
                $check_vendoraccount->vendor_id = $orderdetail->vendor_id;
                $check_vendoraccount->order_id = $orderdetail->order_id;
                $check_vendoraccount->product_id = $orderdetail->product_id;
                $check_vendoraccount->payment_elegible = 'Y';
                $check_vendoraccount->payment_status = 'N';
                $check_vendoraccount->order_date = $orderdetail->created_at;
                $check_vendoraccount->order_pay_date = $payment->created_at??null;
                $check_vendoraccount->update();
            }
       
        return redirect()->back()->withSuccess('UPC successfully');
    }

    public function orderinvoice(Request $request){
        $record['sitesetting'] = Sitesetting::first();
        $order = Order::where('id',$request->id)->first();
        $record['orderdetail'] = Orderdetail::where('order_id',$request->id)->get();
        $subtotal = Orderdetail::where('order_id',$request->id)->sum('discount_rate');
        $record['subtotal'] = $subtotal;
        $record['total'] = $order->order_total;
        $record['order'] = $order;
        return view('admin.order.orderinvoice',$record);
    }

    public function neworderinvoice(Request $request){
        $record['sitesetting'] = Sitesetting::first();
        $order = Order::where('id',$request->id)->first();
        $record['orderdetail'] = Orderdetail::where('order_id',$request->id)->get();
        $subtotal = Orderdetail::where('order_id',$request->id)->sum('discount_rate');
        $record['subtotal'] = $subtotal;
        $record['total'] = $order->order_total;
        $record['order'] = $order;
        return view('admin.order.neworderinvoice',$record);
    }

}
