<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Property;
use File;
use Auth;
use DB;
use Illuminate\Http\Response;
use Yajra\Datatables\Datatables;

class PropertyController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    private $data = array(
        'route' => 'admin.customer.',
        'title' => 'Customer',
        'menu' => 'Customer',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
            $customerSearch = $request->search['value'];
            $records = Property::orderBy('id','DESC')
                                ->when($request->startDate, function ($query) use ($request) {
                                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                    if ($request->endDate) {
                                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                        return $query->whereBetween('customers.created_at', [$startDate, $endDate]);
                                    }
                                    return $query->where('customers.created_at', '>=', $startDate);
                                })
                                ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                    return $query->where('customers.created_at', '<=', $endDate);
                                })
                                ->when($customerSearch, function ($query) use ($customerSearch) {
                                    return $query->where(function ($q) use ($customerSearch) {
                                                $q->where('first_name', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('last_name', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('state', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('email', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('pincode', 'like', '%' . $customerSearch . '%')
                                                    ->orWhere('mobile', 'like', '%' . $customerSearch . '%');
                                            });
                                });
             $sr = 1;
             return Datatables::of($records)
             ->addIndexColumn()
             ->addColumn('sr_no', function ($record) use (&$sr) {
                 return $sr++;
             })

           
             ->addColumn('email_phone', function ($record) {
                $div = "<div class='text-left'>";

                 $div .= "<b>Phone Number:-</b> ".$record->mobile."<br><b>Email:-</b> ".$record->email;

                 $div .="</div>";
                 return $div;   
            })

            ->addColumn('status', function ($record) {
                $statusColors = [
                    'Pending' => 'bg-warning text-dark', // Yellow background, dark text
                    'Active' => 'bg-success text-white', // Green background, white text
                    'Inactive' => ' bg-danger  text-white' // Red border, red text
                ];
            
                $statuses = ['Pending', 'Active', 'Inactive'];
                $options = '';
            
                foreach ($statuses as $status) {
                    $options .= "<li><a href='#' class='dropdown-item' onclick='changeStatus(\"{$status}\", {$record->id})'>{$status}</a></li>";
                }
            
                // Determine current status color classes
                $statusClass = $statusColors[$record->status] ?? 'bg-secondary text-white';
            
                return "
                    <div class='dropdown'>
                        <span id='status-{$record->id}' class='{$statusClass} rounded-pill px-3 py-1 dropdown-toggle' data-bs-toggle='dropdown' role='button' aria-expanded='false'>
                            {$record->status}
                        </span>
                        <ul class='dropdown-menu'>
                            {$options}
                        </ul>
                    </div>
                ";
            })




             ->editColumn('image_name',function ($record){
               
                 $image = <<<HTML


                    <div class="d-flex align-items-center">
                       <div> <img src="https://homy-next.vercel.app/_next/image?url=%2F_next%2Fstatic%2Fmedia%2Fimg_01.26c7b42f.jpg&w=128&q=75" alt="image" style="border-radius:1rem;" class="img-thumbnail mx-3 border-0"  width="150px" height="150px"></div>
                        <div><h4>Galaxy Flat</h4>
                        <p class="mb-1">2BHK</p>
                        <p class="mb-1">Flat</p>
                        <h4>Rs. 55000</h4>
                    </div>
                    </div>



                HTML;
            
                return $image;


             })
             ->editColumn('created_at', function ($record) {
                return $record->created_at->format('d-m-Y H:m a');
            })
          
          
             ->addColumn('action', function ($record) {
                 return '<a class="btn btn-sm btn-primary customerView text-white" data-id="'.$record->id.'" ><i class="fe fe-eye"></i></a> '.
                       '&nbsp;<a href="'.url('admin/customer/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                       '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
             })
             ->rawColumns(['status','action','sr_no','image_name','email_phone'])
             ->make(true);
     }
    
    
    
            return view('admin.property.index',$this->data);
        
    }

   
    public function create()
    {
		$customer = [];
        return view('admin.customer.create')->with(['customer'=>$customer]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'first_name' => 'required',
            'last_name' => 'required',
            'mobile' => 'required|numeric|digits:10|unique:customers,mobile',
			'email' => 'required|email|unique:customers,email',
            'alt_mobile' => [
                'nullable',
                'numeric',
                'digits:10',
                'different:mobile',
                'unique:customers,alt_mobile',
            ],
            'alt_email' => [
                'nullable',
                'email',
                'different:email',
                'unique:customers,alt_email',
            ],
			'state' => 'required',
			'pincode' => 'required|digits:6'
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		$input = $request->all();
		
		// $str = strtolower(trim($request->first_name));
		// $str = preg_replace('/[^a-z0-9-]/', '-', $str);
		// $str = preg_replace('/-+/', "-", $str);
		// $input['slug'] = rtrim($str, '-');
        $customer = Customer::withTrashed()->where('mobile',$request->mobile)->first();
        if(empty($numbers)){
            $admin = new Customer($input);
            $admin->save();
            return redirect('admin/customer')->withSuccess('Added successfully');
        }else{
            if ($customer->trashed()) {
                $customer->restore();
            }
            $input['status'] = 'Active';
            $customer->update($input);
            return redirect('admin/customer')->withSuccess('This Customer already exists.Update successfully');
        }
      
		
       
    }

    public function show($id)
    {
		$customer = Customer::find($id);
        return view('admin.customer.show')->with(['customer'=>$customer]);
    }

    public function customerView(Request $request){
        $customer = Customer::find($request->id);
        $data = [
            'customer' => $customer,
        ];
        return response()->json([
            'success' => true,
            'html' => view('admin.customer.customerView', $data)->render()
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$customer = Customer::find($id);
		
        return view('admin.customer.create',['customer'=>$customer]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$customer = Customer::find($id);
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
            {
            if($request->currentStatus == 'Active')
            {
                $customer->status = 'Deactive';
            }	
            else{
                $customer->status = 'Active';
            }		  
            }
            $customer->save();
            $response['success'] = true;
            $response['message'] = 'Update successfully';
            return response()->json($response);
			 
		 }
       $sValidationRules = [
            'first_name' => 'required',
            'last_name' => 'required',
            'mobile' => 'required|numeric|digits:10|unique:customers,mobile,'.$id.',id',
			'email' => 'required|email|unique:customers,email,'.$id.',id',
            'alt_mobile' => [
                'nullable',
                'numeric',
                'digits:10',
                'different:mobile', // Ensure alt_mobile is different from mobile
                'unique:customers,alt_mobile,'.$id.',id'
            ],
            'alt_email' => [
                'nullable',
                'email',
                'different:email', // Ensure alt_email is different from email
                'unique:customers,alt_email,'.$id.',id'
            ],
			'state' => 'required',
			'pincode' => 'required|digits:6'
        ];
       
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
     
        $customer->update($input);
        return redirect('admin/customer')->withSuccess('Update successfully');
    }

 
    public function destroy(Request $request)
    {
        $admin = Customer::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Customer::where('id', '=', $request->id)->delete();
        return redirect(route('admin.customer'))->withSuccess('Deleted successfully');
    }
	
	 public function customerdelete($id)
    {
      
        Customer::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
}
