<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Team;
use File;
use Auth;
use DB;
 
class TeamController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
          
            $query = Team::where('id','>','0');
            // Search Start
          
            $count = $query->count();
            $result = $query->orderBy('id','DESC')->paginate(5);
            return view('admin.team.index')->with(['result'=>$result]);
        
    }

   
    public function create()
    {
		$team = [];
        return view('admin.team.create')->with(['team'=>$team]);
    }

   
    public function store(Request $request)
    {
	
        $sValidationRules = [
            'name' => 'required',
            'designation' => 'required',
            'description' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		

		$admin = New Team;
		$admin->name = $request->name;
		$admin->description = $request->description;
		$admin->designation = $request->designation;
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
       
       
          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/team'), $image);
            $admin->image = 'uploads/team/'.$image;
        } 
        
        $admin->save();
       
        return redirect('admin/team')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$team = Team::find($id);
        return view('admin.team.show')->with(['team'=>$team]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$team = Team::find($id);
		
        return view('admin.team.create',['team'=>$team]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$team = Team::find($id);
	
		 if ($request->ajax()) {
			
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $team->status = 'Deactive';
		  }	
          else{
			  $team->status = 'Active';
		  }		  
		}
		  $team->save();
		  return 1;
		
			 
		 }
        $sValidationRules = [
             'name' => 'required',
             'designation' => 'required',
             'description' => 'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($team->image))){
                unlink(asset($team->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/team'), $image);
            $input['image'] = 'uploads/team/'.$image;
        } 
        $team->update($input);
        return redirect('admin/team')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = team::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Team::where('id', '=', $request->id)->delete();
        return redirect(route('admin.team'))->withSuccess('Deleted successfully');
    }
	
	 public function teamdelete($id)
    {
        $admin = Team::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Team::where('id', '=', $id)->delete();
        return 1;
    }
}
