<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use App\Models\Vendor;
use App\Models\Phonenumber;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\Cache;
use File;
use Auth;
use DB;
 
class VendorController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.vendor.',
        'title' => 'Vendor',
        'menu' => 'Vendor',
        'submenu' => '',
    );


    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
           
                $records = Vendor::where('status', $request->status)
                                    ->orderBy('id', 'DESC');
                                    
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
                ->editColumn('vendor_status',function ($record){
                    return 'Yes';
                })
                // ->editColumn('total_number',function ($record){
                //     $number_count = Phonenumber::where('vendor_id', $record->id)->count();
                //     return $number_count;
                // })
                ->editColumn('total_avilable_number',function ($record){
                    // $number_count = Phonenumber::where('vendor_id', $record->id)->where('status', 'Available')->count();
                    return $record->total_available_number;
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch d-flex justify-content-end">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/vendor/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                          '&nbsp;<a href="'.url('admin/vendor/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','sr_no'])
                ->make(true);
        }
        $this->data['status'] = $request->status;
       
        return view('admin.vendor.index',$this->data);
    
}

        
    

   
    public function create()
    {
		$vendor = [];
        return view('admin.vendor.create')->with(['vendor'=>$vendor]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'name' => 'required',
			'nick_name' => 'required',
            'email' => 'required',
            'password' => 'required',
            'address' => 'required',
            'area' => 'required',
            'mobile' => 'required|numeric|digits:10',
            'website' => 'required',
            'paytm_number' => 'required',
            'gpay_number' => 'required',
            'area' => 'required',
            'bank_name' => 'required',
            'account_name' => 'required',
            'account_number' => 'required',
            'branch_location' => 'required',
            'ifsc_code' => 'required',
            'register_vendor' => 'required',
            // 'aadhar_image' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/vendor/create')->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
	
		
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
        if($request->hasFile('aadhar_image')){
            $image = rand().time().'.'.$request->aadhar_image->extension();
            $request->aadhar_image->move(public_path('uploads/aadhar_image'), $image);
            $input['aadhar_image'] = 'uploads/aadhar_image/'.$image;
        } 

       	$admin = New Vendor($input);
        
        
        $admin->save();
		
        return redirect('admin/vendor')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$vendor = Vendor::find($id);
        return view('admin.vendor.show')->with(['vendor'=>$vendor]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$vendor = Vendor::find($id);
		
        return view('admin.vendor.create',['vendor'=>$vendor]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$vendor = Vendor::find($id);
       
		 if ($request->ajax()) {
			 
            if(!empty($request->currentStatus))
            {
                if($request->currentStatus == 'Active')
                {
                    $vendor->status = 'Deactive';

                     Phonenumber::where('vendor_id', $vendor->id)->where('status','Available')->update(['status'=>'vendor_deactivated']);
                }	
                else{
                    $vendor->status = 'Active';

                    Phonenumber::where('vendor_id', $vendor->id)->where('status','vendor_deactivated')->update(['status'=>'Available']);

                }		  
            }
		  $vendor->save();
          $response['message'] = 'Status Updated Successfully.';
          $response['result'] = '1';
		  return $response;
		
			 
		 }
        $sValidationRules = [
            'name' => 'required',
			'nick_name' => 'required',
            'email' => 'required',
            'password' => 'required',
            'address' => 'required',
            'area' => 'required',
            'mobile' => 'required|numeric|digits:10',
            'website' => 'required',
            'paytm_number' => 'required',
            'gpay_number' => 'required',
            'area' => 'required',
            'bank_name' => 'required',
            'account_name' => 'required',
            'account_number' => 'required',
            'branch_location' => 'required',
            'ifsc_code' => 'required',
            'register_vendor' => 'required',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
       
        if($request->hasFile('aadhar_image')){
            if(file_exists(asset($vendor->aadhar_image))){
                unlink(asset($vendor->aadhar_image));
            }
            $image = rand().time().'.'.$request->aadhar_image->extension();
            $request->aadhar_image->move(public_path('uploads/aadhar_image'), $image);
            $input['aadhar_image'] = 'uploads/aadhar_image/'.$image;
        } 
        
        $vendor->update($input);
        return redirect('admin/vendor')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Vendor::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Vendor::where('id', '=', $admin->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	 public function vendordelete($id)
    {
        $admin = Vendor::find($id);
       
        Vendor::where('id', '=', $id)->delete();
        return 1;
    }

    public function deleteVendorProduct(){

        $vendors = Vendor::where('status','Active')->get();
        return view('admin.vendor.deleteVendorProduct',['vendors'=>$vendors]);
    }

    public function deleteallvendor(Request $request){

    
        Phonenumber::where('vendor_id', $request->vendor_id)->where('status','Available')->update(['status'=>'sold_by_vendor']);

        return redirect()->back()->withSuccess('Update all vendor');
    }


}
