<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Vendor;
use App\Models\VendorAccount;
use App\Models\Phonenumber;
use App\Models\VendorPayment;
use App\Models\Category;
use Yajra\Datatables\Datatables;


class VendorCreditController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.vendorcredit.',
        'title' => 'Vendor Credit',
        'menu' => 'vendorcredit',
        'submenu' => '',
    );

    public function index(Request $request)
    {
      
            if ($request->ajax()) {
               
                /* $records = VendorAccount::select('vendor_accounts.*','orderdetails.order_number','orderdetails.order_date as orderdetails_order_date','orderdetails.vendor_rate','orderdetails.product_name')
                    ->join('orderdetails', function ($join) {
                        $join->on('orderdetails.order_id', '=', 'vendor_accounts.order_id')
                            ->on('orderdetails.product_id', '=', 'vendor_accounts.product_id');
                    })->where('vendor_accounts.vendor_id',$request->vendor_id)->orderBy('vendor_accounts.id','DESC');
                    $sr = 1;
                    return Datatables::of($records)
                        ->addIndexColumn()
                        ->addColumn('sr_no', function ($record) use (&$sr) {
                            return $sr++;
                        }) 
                        ->addColumn('action', function ($record) {
                            if($record->payment_status != 'C'){
                                return '<input type="checkbox" class="checkbox" value="'.$record->id.'">';
                            }else{
                                return '';
                            }
                        }) 
                        ->editColumn('payment_status', function ($record) {
                            if($record->payment_status == 'Y'){
                                return 'PAID';
                            }elseif($record->payment_status == 'N'){
                                return 'Pending';
                            }else{
                                return 'Cancelled';
                            }
                        })
                        ->rawColumns(['action'])
                        ->make(true);
                }*/

            }
            $records = VendorAccount::select('vendor_accounts.*','orderdetails.order_number','orderdetails.order_date as orderdetails_order_date','orderdetails.vendor_rate','orderdetails.product_name')
                ->join('orderdetails', function ($join) {
                    $join->on('orderdetails.order_id', '=', 'vendor_accounts.order_id')
                        ->on('orderdetails.product_id', '=', 'vendor_accounts.product_id');
                })->where('vendor_accounts.vendor_id',$request->vendorid)->orderBy('vendor_accounts.id','DESC')->get();
            
            
           
            
      
        $this->data['records'] = $records;
        $this->data['vendor_id'] = $request->vendorid;
        return view('admin.vendorcredit.index',$this->data);
    }
  
   public function vendorPaymentStatus(Request $request){
    $checkboxValue = $request->all();
    $resultArray = array_keys($checkboxValue);
    $vProductId = implode(',', $resultArray);
    $this->data['vProductId'] = $vProductId;
    return view('admin.vendorcredit.vendorPaymentStatus',$this->data);
   }

   public function vendorPaymentStatusUpdate(Request $request){
        foreach(explode(',', $request->vProductId) as $ProductId){
           $data = VendorAccount::where('id',$ProductId)->first();
           if($request->payment_status == 'N'){
                $data->payment_status = $request->payment_status;
                $data->payment_date = null;
                $data->save();
           }else{
                $data->payment_status = $request->payment_status;
                $data->payment_date = $request->paymentDate;
                $data->save();
           }
        }
        return redirect()->route('vendorcredit.index', ['vendorid' => $data->vendor_id])->with('success', 'Vendor Payment Status updated successfully.');
   }

   public function vendorproduct(Request $request)
   {
    if ($request->ajax()) {
       
        if(!empty($request->vendor_id))
        {
       
          $records = Phonenumber::with('category','vendor')->select('phonenumbers.*')->where('phonenumbers.vendor_id',$request->vendor_id??"")->orderBy('id','DESC');
        }
        else{
            $records= [];
        }
         $sr = 1;
        return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('sr_no', function ($record) use (&$sr) {
                return $sr++;
            })
            ->editColumn('updated_at', function ($record) {
                return $record->updated_at->format('d-m-Y H:m:s');
            })
            ->editColumn('status', function ($record) {
                return '<span style="color:#0162e8;">'.$record->status.'</span>';
            })
            ->addColumn('action', function ($record) {
                return '<a href="'.url('admin/phone/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                      '&nbsp;<a href="'.url('admin/phone/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                      '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
            })

            ->rawColumns(['status','action','sr_no'])
            ->make(true);
    }
    $this->data['status'] = $request->status;
    $this->data['vendor'] = Vendor::get();
    return view('admin.phonenumber.vendorproduct',$this->data);

   }

   public function vendordebit(Request $request,$id)
   {
   
    if ($request->ajax()) {
        
        
        $records = VendorPayment::with('vendor')->where('vendor_payments.vendor_id',$id)->select('vendor_payments.*')->orderBy('vendor_payments.id','desc');
       
        $sr = 1;
        return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('sr_no', function ($record) use (&$sr) {
                return $sr++;
            }) 
            ->editColumn('payment_date', function ($record) {
                return date('d-m-Y',strtotime($record->payment_date));
            })
            ->editColumn('remarks', function ($record) {
                return strip_tags($record->ramarks);
            })
            ->addColumn('action', function ($record) {
                return '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
            })
            ->rawColumns(['action'])
            ->make(true);
    }
    $this->data['vendor_id'] = $id;
   
    return view('admin.vendorcredit.vendordebit',$this->data);

   }
}
