<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Wishlist;
use File;
use Auth;
use DB;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
class WishlistController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.wishlist.',
        'title' => 'Wishlist',
        'menu' => 'Wishlist',
        'submenu' => '',
    );

    public function index(Request $request)
    {
       
            if ($request->ajax()) {
                $records = Wishlist::select('wishlists.*')->with(['number','user'])
                                        ->join('phonenumbers','phonenumbers.id','wishlists.number_id')
                                        ->where('phonenumbers.status','Available')
                                        ->whereNull('phonenumbers.deleted_at')->orderBy('id','DESC')
                                        ->when($request->startDate, function ($query) use ($request) {
                                            $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                            if ($request->endDate) {
                                                $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                                return $query->whereBetween('wishlists.created_at', [$startDate, $endDate]);
                                            }
                                            return $query->where('wishlists.created_at', '>=', $startDate);
                                        })
                                        ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                            $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                            return $query->where('wishlists.created_at', '<=', $endDate);
                                        });
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->editColumn('full_name',function ($record){
                        return $record->user->first_name.' '.$record->user->last_name;
                    })
                    ->editColumn('email',function ($record){
                        return $record->user->email;
                    })
                    ->editColumn('mobile',function ($record){
                        return $record->user->mobile;
                    })
                    ->editColumn('product',function ($record){
                        return $record->number->number;
                    })
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format('d-m-Y H:i:s');
                    })
                    ->make(true);
            }
            return view('admin.wishlist.index',$this->data);
        
    }
 
}
