<?php

namespace App\Http\Controllers\UserAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sitesetting;
use App\Models\Product;
use App\Models\Category;

class ProductsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     *
     * @return \Illuminate\Http\Response
     */


    public function index($slug)
    {
        $sitesetting = Sitesetting::first();
        $category = Category::where('slug', $slug)->firstOrFail();
        $products = Product::where('status', 'Active')->where('category_id', $category->id)->orderBy('id', 'desc')->paginate(12);
    
        return view('user.products', compact('sitesetting', 'products', 'category'));
    }

    public function productdetails($category_slug, $product_slug)
    {
        $sitesetting = Sitesetting::first();
        $category = Category::where('slug', $category_slug)->firstOrFail();
        $product = Product::where('slug', $product_slug)->where('category_id', $category->id)->where('status', 'Active')->firstOrFail();

        return view('user.productdetails', compact('sitesetting', 'category', 'product'));
    }

     
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
  
}
