<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class About extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'abouts';
    protected $fillable = [
        'mission',
        'vision',
     
        'values_description',
        'mission_image',
        'vision_image',
        'values_image',
   
    ];
	
	protected $appends = ['mission_image_url','vision_image_url','values_image_url'];

	

    public function getMissionImageUrlAttribute($value)

    {

        return  !empty($this->attributes['mission_image'])? asset($this->attributes['mission_image']):null;

    }


    public function getVisionImageUrlAttribute($value)

    {

        return  !empty($this->attributes['vision_image'])? asset($this->attributes['vision_image']):null;

    }


    public function getValuesImageUrlAttribute($value)

    {

        return  !empty($this->attributes['values_image'])? asset($this->attributes['values_image']):null;

    }

}
