<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'categories';
    protected $fillable = [
        'name',
        'slug',
        'image',
  
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;


    }

    public function categoryImages()
    {
        return $this->hasMany(CategoryImage::class);
    }



    public function products()
    {
        return $this->hasMany(Product::class);
    }
}
