<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;

class Order extends Model
{
    use HasFactory, SoftDeletes;
    // protected $table = 'vendors';
    protected $fillable = [
        'order_number',
        'customer_id',
		'name',
        'mobile_no',
		'order_total',
		'gst_amount',
        'payment_status',
        'order_status',
        'assign_to',
        'order_date',
        'shipping_charge',
        'gst_status'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_id');
    }

    public function employee()
    {
        return $this->belongsTo(Admin::class,'assign_to');
    }
    public function orderdetails()
    {
        return $this->hasMany(Orderdetail::class, 'order_id');
    }

  
	
}
