<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orderdetail extends Model
{
    use HasFactory,SoftDeletes;
    // protected $table = 'vendors';
    protected $fillable = [
        'order_number',
        'vendor_id',
        'order_id',
		'product_id',
        'product_name',
        'order_date',
        'upc_no',
        'number_rate',
        'vendor_rate',
        'status',
    ];

    public function order()
    {
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

    public function vendor()
    {
        return $this->belongsTo('App\Models\Vendor', 'vendor_id');
    }

}
