<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'payments';
    protected $fillable = [
        'order_id',
        'customer_id',
        'card_name',
        'order_number',
		'payment_type',
        'amount',
        'payment_mode',
        'txn_id',
        'approval_sms',
        'remarks',
		'image',
        'status'
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
 
    // public function customer()
    // {
    //     return $this->belongsTo(Customer::class,'customer_id');
    // }
    public function customer()
    {
        return $this->belongsTo('App\Models\Customer','customer_id');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order','order_id');
    }

   
}
