<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sitesetting extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'sitesettings';
    protected $fillable = [
         'comp_name', 'meta_tag', 'meta_desc', 'footer_logo', 'fevicon', 'image', 'comp_address', 'contact_phone_name1', 'comp_phone', 'contact_phone_name2', 'comp_phone2', 'whatsapp_number', 'contact_email_name1', 'comp_email2', 'contact_email_name2', 'comp_email', 'comp_tweeter', 'comp_fb', 'linkdin_link', 'insta_link','youtube_link', 'abt_detail','pinterest_link','ifram','google_tag','meta_tag2','meta_tag6','meta_tag3','meta_tag4','meta_tag5','offer_number_id','gst_invoice_perameter','without_gst_invoice_perameter','invoice_year','invoice_nogst','invoice_no','app_link','about_img_1','about_img_2','about_img_3','about_img_4','PhonePe','Razorpay','PhonePeApp','RazorpayApp','meta_keyword','about_title','years_of_experience'
    ];
	
	
		protected $appends = ['image_url','footer_logo_url','fevicon_url','about_img_1_url','about_img_2_url','about_img_3_url','about_img_4_url'];

	

    public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
	public function getFooterLogoUrlAttribute($value)

    {

        return  !empty($this->attributes['footer_logo'])? asset($this->attributes['footer_logo']):null;

    }
	public function getFeviconUrlAttribute($value)
    {
        return  !empty($this->attributes['fevicon'])? asset($this->attributes['fevicon']):null;
    }
    public function getAboutImg1UrlAttribute($value)
    {
        return  !empty($this->attributes['about_img_1'])? url($this->attributes['about_img_1']):null;
    }
    public function getAboutImg2UrlAttribute($value)
    {
        return  !empty($this->attributes['about_img_2'])? url($this->attributes['about_img_2']):null;
    }
    public function getAboutImg3UrlAttribute($value)
    {
        return  !empty($this->attributes['about_img_3'])? url($this->attributes['about_img_3']):null;
    }
    public function getAboutImg4UrlAttribute($value)
    {
        return  !empty($this->attributes['about_img_4'])? url($this->attributes['about_img_4']):null;
    }

    
}
