@extends('admin.layout.app')

@section('content')


<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Coupon Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Coupon Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/coupon/create') }}"><button type="button" class="btn btn-primary">Add Coupon</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Coupon Details</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >Coupon Code</th>
                                        <th >Coupon Type</th>
                                        <th >Coupon Value</th>
                                        {{-- <th >Max Discount Value</th> --}}
                                        <th >Minimum Cart Value</th>
                                        <th >Maxmum Cart Value</th>
                                        <th >Valid Upto	</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
    /*$(document).ready(function () {
        $('.js-example-basic-multiple').select2();
    });*/
   jQuery(document).ready(function () {
    /*$("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');*/
    var oTable = $('#example1').DataTable({
			autoWidth: false,
			processing: true,
			serverSide: true,
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
			ajax:{ 
                url: "{{ url('admin/coupon') }}",
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                },
             },
			columns: [
				{data: 'coupon_code', name: 'coupon_code',className : 'text-center', defaultContent: '-'},
                {data: 'coupon_type', name: 'coupon_type',orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'coupon_value', name: 'coupon_value',orderable : false,className : 'text-center', defaultContent: '-'},
				// { data: 'max_discount_value', name: 'max_discount_value',orderable : false,className : 'text-center' },
                {data: 'minimum_cart_value', name: 'minimum_cart_value',orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'maxmum_cart_value', name: 'maxmum_cart_value',orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'valid_upto', name: 'valid_upto',orderable : false,className : 'text-center', defaultContent: '-'},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center', defaultContent: '-'},
			]
    });
    // you want to Change this Number Status ?
    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    var obj = jQuery(this);
                    var id = obj.attr('data-id');
                    $.ajax({
                        type: "DELETE",
                        url: "{{ url('admin/coupon')  }}/" + id,
                        data: {
                            id: id,
                            _token: "{{ csrf_token() }}"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            $(this).attr('disabled', true);
                            $('.alert .msg-content').html('');
                            $('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true){
                                oTable.ajax.reload();
                                toastr.success(resp.message);
                            }
                        },
                        error: function (e) {
                            alert('Error: ' + e);
                        }
                    });
                }
            });
            
    });
		
});

</script>
@endsection