@extends('admin.layout.app')

@section('content')
<style>
     .hidden { display: none; }
</style>

<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="left-content">
                @php  $user = Auth::guard('admin')->user();  @endphp
                <div>
                    <h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1">Hi,{{$user->name}} !</h2>
                </div>
        
            </div>

            <h4 class="text-center" style="cursor: pointer;" onclick="resetFilter();" id="resetFilterBtn"> <i class="fe fe-refresh-cw" style="color: #2278bc;"></i> Reset Filters</h4>

            {{-- <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        
                        <form id="filterForm" method="GET" action="{{ route('admin.dashboard') }}">
                            <input type="hidden" name="startDate" id="startDate" value="{{ request()->startDate }}" />
                            <input type="hidden" name="endDate" id="endDate" value="{{ request()->endDate }}" />
                        </form>
                    </div>
                </div>
            </div> --}}
        </div>
        <div class="row row-sm">
            <div class="col-lg-6 col-xl-3 col-md-6 col-12">
                <div class="card bg-warning-gradient text-white">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="icon1 mt-2 text-center">
                                    <i class="fe fe-layers tx-40"></i>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mt-0 text-center">
                                    <span class="text-white d-block">Total Sliders</span>
                                    <h2 class="text-white mb-0">
                                        <a href="{{ url('admin/slider') }}" target="_blank" style="color: #ffffff; text-decoration: none;">
                                            {{ $sliderCount ?? '00' }}
                                        </a>
                                    </h2>
                                </div>                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-xl-3 col-md-6 col-12">
                <div class="card bg-primary-gradient text-white ">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="icon1 mt-2 text-center">
                                    <i class="fe fe-message-square tx-40"></i>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mt-0 text-center">
                                    <span class="text-white d-block">Total Testimonials</span>
                                    <h2 class="text-white mb-0">
                                        <a href="{{ url('admin/testimonial') }}" target="_blank" style="color: #ffffff; text-decoration: none;">
                                            {{ $testimonialCount ?? '00' }}
                                        </a>
                                    </h2>
                                </div>                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-xl-3 col-md-6 col-12">
                <div class="card bg-danger-gradient text-white">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="icon1 mt-2 text-center">
                                    <i class="fe fe-briefcase tx-40"></i>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mt-0 text-center">
                                    <span class="text-white d-block">Total Services</span>
                                    <h2 class="text-white mb-0">
                                        <a href="{{ url('admin/service') }}" target="_blank" style="color: #ffffff; text-decoration: none;">
                                            {{ $serviceCount ?? '00' }}
                                        </a>
                                    </h2>
                                </div> 
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-xl-3 col-md-6 col-12">
                <div class="card bg-success-gradient text-white">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="icon1 mt-2 text-center">
                                    <i class="fe fe-image tx-40"></i>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mt-0 text-center">
                                    <span class="text-white d-block">Total Media</span>
                                    <h2 class="text-white mb-0">
                                        <a href="{{ url('admin/media') }}" target="_blank" style="color: #ffffff; text-decoration: none;">
                                            {{ $mediaCount ?? '00' }}
                                        </a>
                                    </h2>
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- /main-content -->



@endsection

@section('js')
<script>
   

$(function() {
    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $('#startDate').val(start.format('YYYY-MM-DD'));
        $('#endDate').val(end.format('YYYY-MM-DD'));
        $('#filterForm').submit(); // Submit the form to filter results
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    // cb(start, end);
});
function resetFilter(){
    var url = '{{ url("admin/dashboard") }}';
    window.location.href = url;
}
checkFilters();
function checkFilters() {
    var urlParams = new URLSearchParams(window.location.search);

    var filters = ['startDate', 'endDate'];
    var isFilterSet = filters.some(param => urlParams.get(param) && urlParams.get(param) !== '');

    var resetFilterBtn = document.getElementById('resetFilterBtn');
    if (isFilterSet) {
        resetFilterBtn.classList.remove('hidden');
    } else {
        resetFilterBtn.classList.add('hidden');
    }
}
</script>
@endsection