@extends('admin.layout.app')

@section('content')
<style>
    .dataTables_wrapper { overflow-x: auto; }
</style>

<div class="main-content app-content">
    <div class="main-container container-fluid">

        <!-- Breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Forecast</h4>
                    <span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Forecast List</span>
                </div>
            </div>
        </div>

        <!-- Table Card -->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Forecast List</h4>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive" style="overflow-x:auto;">
                            <table class="border-top-0 table table-bordered key-buttons border-bottom text-nowrap dataTable no-footer"
                                   id="forecastDataTable">
                                <thead>
                                    <tr>
                                        <th><span>Title</span></th>
                                        <th><span>Description</span></th>
                                        <th><span>Start Date</span></th>
                                        <th><span>End Date</span></th>
                                        <th><span>Image</span></th>
                                        <th><span>Created At</span></th>
                                        <th><span>Action</span></th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    var oTable = $('#forecastDataTable').DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
        "processing": true,
        "serverSide": true,
        "dom": 'lBfrtip',
        "ajax": {
            url: "{{ url('admin/forecast') }}",
            type: 'GET',
            data: { "_token": "{{ csrf_token() }}" }
        },
        "columns": [
            {
                data: 'title',
                name: 'title',
                render: function(data, type, row) {
                    if (!data) return '-';
                    var clean = data.replace(/<\/?[^>]+(>|$)/g, '')
                        .replace(/&nbsp;/g, ' ')
                        .replace(/&amp;/g, '&')
                        .replace(/&lt;/g, '<')
                        .replace(/&gt;/g, '>')
                        .replace(/&quot;/g, '"')
                        .replace(/&#039;/g, "'")
                        .trim();

                    var short = clean.length > 30 ? clean.substr(0, 30) + '...' : clean;
                    return '<span title="' + clean + '">' + short + '</span>';
                }
            },
            {
                data: 'description',
                name: 'description',
                render: function(data, type, row) {
                    if (!data) return '-';

                    var clean = data.replace(/<\/?[^>]+(>|$)/g, '')
                    .replace(/&amp;/g, '&')
                        .replace(/&lt;/g, '<')
                        .replace(/&gt;/g, '>')
                        .replace(/<[^>]*>/g, '') 
                        .replace(/&nbsp;|&#160;/gi, ' ')
                        .replace(/&[a-z0-9#]+;/gi, ' ')
                        .replace(/\s+/g, ' ')
                        .trim();

                    var first = clean.split(/[।.?!]/)[0].trim();

                    var short = first.length > 40 ? first.substr(0, 40) + '...' : first;

                    return '<span title="' + clean + '" style="cursor:help;">' + short + '</span>';
                }
            },
            { data: 'start_date', name: 'start_date' },
            { data: 'end_date', name: 'end_date' },
            { data: 'image', name: 'image', searchable: false, orderable: false, className: 'text-center' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action', searchable: false, orderable: false, className: 'text-center' }
        ]
    });

</script>
@endsection