<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Lifetime Number |Order Invoice</title>
    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">
    <link rel="stylesheet" href="{{ url('assets/admin') }}/orderinvoice/bootstrap.min.css" type="text/css" />
    <link rel="stylesheet" href="{{ url('assets/admin') }}/orderinvoice/style.css" type="text/css" />
</head>
<body>
    <div class="book">
        <div class="page">
            <div class="subpage">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td>
                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                <tr>
                                    <td align="center" colspan="2">
                                        <img src="{{url($sitesetting->image)}}" style="width:100px">
                                    </td>
                                </tr>
                                <tr>
                                    <td width="50%">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                            <tr>
                                                <td>
                                                    {!! $sitesetting->comp_address !!}
                                                </td>
                                            </tr>
                                            {{-- <tr>
                                                <td>
                                                    Buyer (Bill to) <br>
                                                    <b>[Company Name]</b> <br>
                                                    [Address] <br>
                                                    GSTIN/UIN : [GSTIN] <br>
                                                    State Name : [State] <br>
                                                </td>
                                            </tr> --}}
                                        </table>
                                    </td>
                                    <td width="50%" valign="top">
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                            <tr>
                                                <td>
                                                    Invoice No. <br>
                                                    <b>{{$order->invoice_no}}</b>
                                                </td>
                                                <td>
                                                    Dated <br>
                                                    <b>{{date('d/m/Y',strtotime($order->order_date))}}</b>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2">
                                                    Buyer (Bill to) <br>
                                                    <strong>{{$order->customer->first_name}} {{$order->customer->last_name}}
                                                    </strong><br>
                                                    {{$order->customer->address}}
                                                    <br />{{$order->customer->pincode}}<br />{{$order->customer->state}}<br />
                                                    {{$order->customer->company_name??''}}<br />
                                                    {{$order->customer->gst_number??''}}<br />
                                                </td>
                                            </tr>
                                            {{-- <tr>
                                                <td>
                                                    &nbsp;
                                                </td>
                                                <td>
                                                    Model/ Terms of Payment <br>
                                                    <b>30 Days</b>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Buyer's PO NO. <br>
                                                    <b>[PO Number]</b>
                                                </td>
                                                <td>
                                                    PO Dated <br>
                                                    <b>[PO Date]</b>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2">
                                                    Terms of Delivery
                                                </td>
                                            </tr> --}}
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                <tr align="center">
                                    <th>Sr. No.</th>
                                    <th>Particular's</th>
                                    <th>Rate</th>
                                    <th>Discount</th>
                                    <th>Amount</th>
                                </tr>
                                @php
                                    $sr = 1;
                                @endphp
                                @foreach ($orderdetail as $number)
                                    <tr valign="top" align="center">
                                        <td>{{$sr++}}</td>
                                        <td align="left">
                                            <b>For Vanity Number &nbsp;</b>
                                            <br>
                                            <span><em>{{$number->product_name}}</em></span> <br>
                                            @if ($loop->last && !empty($order->gst_amount))
                                                <p align="right" style="margin: 0;"><b >CGST Output-9%</b></p>
                                                <p align="right" style="margin: 0;"><b >SGST Output-9%</b></p>
                                            @endif
                                        </td>
                                        <td >{{round($number->number_rate)}}</td>
                                        <td >{{$number->discount}} </td>
                                        <td >
                                             {{round($number->discount_rate)}} <br> <br>
                                             @if ($loop->last && !empty($order->gst_amount))
                                                <p align="center" style="margin: 0;"><b >{{round($order->gst_amount/2,2)}}</b></p>
                                                <p align="center" style="margin: 0;"><b >{{round($order->gst_amount/2,2)}}</b></p>
                                             @endif
                                        </td>
                                    </tr>
                                @endforeach
                                <tr align="center">
                                    <td></td>
                                    <td align="right"><b>Total Payable</b></td>
                                    <td></td>
                                    <td align="right"><b></b></td>
                                    <td >Rs. {{round($total)}}</td>
                                </tr>
                                <tr>
                                    <td colspan="7">Amount (in words) : &nbsp; <b>{{NumberToWords(round($total))}}</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                <tr align="center">
                                    <td width="50%">Order Id</td>
                                    <td>Taxable Value</td>
                                    <td>Central Tax</td>
                                    <td>State Tax</td>
                                    <td>Total Tax Amount</td>
                                </tr>
                                <tr valign="top">
                                    <td align="center">{{$order->order_number}}</td>
                                    <td align="right">{{round($total - $order->gst_amount??0)}}</td>
                                    <td align="right">{{round($order->gst_amount/2,2)}}</td>
                                    <td align="right">{{round($order->gst_amount/2,2)}}</td>
                                    <td align="right"><b>{{round($total)}}</b></td>
                                </tr>
                                <tr>
                                    <td align="right"><b>Total</b></td>
                                    <td align="right"><b>{{round($total - $order->gst_amount??0)}}</b></td>
                                    <td align="right"><b>{{round($order->gst_amount/2,2)}}</b></td>
                                    <td align="right"><b>{{round($order->gst_amount/2,2)}}</b></td>
                                    <td align="right"><b>{{round($total)}}</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    {{-- <tr>
                        <td>
                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                <tr align="center">
                                    <td width="50%">HSN/SAC Code</td>
                                    <td>Taxable Value</td>
                                    <td>Integrated Tax</td>
                                    <td>Total Amount</td>
                                </tr>
                                <tr valign="top">
                                    <td align="center">[HSN Code]</td>
                                    <td align="right">[Taxable Value]</td>
                                    <td align="right">[Integrated Tax]</td>
                                    <td align="right">[Total Amount]</td>
                                </tr>
                                <tr>
                                    <td align="right"><b>Total</b></td>
                                    <td align="right"><b>[Taxable Value]</b></td>
                                    <td align="right"><b>[Integrated Tax]</b></td>
                                    <td align="right"><b>[Total Amount]</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr> --}}
                    <tr>
                        <td>
                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding" style="border-collapse: initial;">
                                <tr>
                                    <td colspan="2" style="border: 0px; border-right: solid 1px #000; border-left: solid 1px #000;">Total (Amount in word) : <b>{{NumberToWords($total)}}</b></td>
                                </tr>
                                <tr>
                                    <td valign="middle" width="50%" style="">
                                        <u>Declaration</u> <br> Terms and Conditions : 1) Payments to be made in the indicated currency, by indicated due date. 2) All tax amounts indicated in the invoice are to be made along with invoiced amount. by indicated due date. 3) This invoice has been raised pursuant to terms of contract, scope and deliverables.
                                    </td>
                                    {{-- <td valign="bottom" width="50%" style="border-top: 0px; border-left: 0px;">
                                        <b>Company's Bank Details</b> <br>
                                        A/c Holder's Name : TECHGATE DIGITAL SERVICES LLP<br>
                                        Bank Name : HDFC BANK LTD<br>
                                        A/C No : 50200094351842 <br>
                                        IFSC Code : HDFC0000276 <br>
                                        Branch : VASANT VIHAR - POKHRAN ROAD 2
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="padding">
                                            <tr>
                                                <td align="right">
                                                    <b>for TECHGATE DIGITAL SERVICES LLP</b> <br>
                                                    SHILPA AGARWAL <br>
                                                    <b>Authorised Signatory</b>
                                                </td>
                                            </tr>
                                        </table>
                                    </td> --}}
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <p style="text-align: center; margin-top: 10px;">This is system generated invoice and does not require any stamp or signature</p>
            </div>
        </div>
    </div>
    <script src="{{ url('assets/admin') }}/orderinvoice/js/jquery.min.js"></script>
    <script src="{{ url('assets/admin') }}/orderinvoice/js/bootstrap.min.js"></script>
</body>
</html>
