@extends('admin.layout.app')

@section('content')
<style>
    .dt-buttons.btn-group {
        position: absolute;
        top: 50px;
        left: 178px;
    }
</style>

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Numbers Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Numbers Details </span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/phone/create') }}"><button type="button" class="btn btn-primary">Add Numbers</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Numbers Details</h4>
                            <input type="hidden" id="status" value="{{$status}}">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR No</th>
                                        <th >Sequence</th>
                                        <th >Number</th>
                                        <th >Rate</th>
                                        <th >Vender Rate</th>
                                        <th >Vender</th>
                                        <!-- <th >Category</th>
                                        <th >Sum Total</th> -->
                                        <th >Dealer Name</th>
                                        <th >Discount%</th>
                                        <th >Update Date</th>
                                        <th >Status</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
// $(document).ready(function () {
//     $('.js-example-basic-multiple').select2();
// });
   jQuery(document).ready(function () {
    // $("#example1").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    var status = $('#status').val();
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
			ajax:{ 
                url: "{{ url('admin/phone') }}",
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                    "status": status,
                },
             },
			columns: [
				{data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'sequence', name: 'sequence',orderable : false,className : 'text-center'},
                {data: 'actual_number', name: 'actual_number',orderable : false,className : 'text-center'},
                {data: 'number_rate', name: 'number_rate',orderable : false,className : 'text-center'},
                {data: 'vendor_rate', name: 'vendor_rate',orderable : false,className : 'text-center'},
                { data: 'vendor.name', name: 'vendor.name', defaultContent: '-', searchable: false,orderable : false ,className : 'text-center'},
				// { data: 'category.name', name: 'category.name', defaultContent: '-', searchable: false,orderable : false,className : 'text-center' },
                // {data: 'total_number', name: 'total_number',orderable : false,className : 'text-center'},
                {data: 'dealer_name', name: 'dealer_name',orderable : false,className : 'text-center'},
                {data: 'discount', name: 'discount',orderable : false,className : 'text-center'},
				{data: 'updated_at', name: 'updated_at',orderable : false,className : 'text-center'},
				{data: 'status', name: 'status', searchable: false,orderable : false,className : 'text-center'},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
    });

    $("#example1").on('change', '.change_numberstatus', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "you want to Change this Number Status ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var status = $(this).val();
                jQuery.ajax({
                    url: "{{ url('admin/phone') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "status":status,
                    },
                    success: function (data) {
                        if(data.success == true){
                            toastr.success(data.message);
                            oTable.ajax.reload();
                        }else{
                            toastr.error(data.message);
                            oTable.ajax.reload();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
    // you want to Change this Number Status ?
    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    var obj = jQuery(this);
                    var id = obj.attr('data-id');
                    $.ajax({
                        type: "DELETE",
                        url: "{{ url('admin/phone')  }}/" + id,
                        data: {
                            id: id,
                            _token: "{{ csrf_token() }}"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            $(this).attr('disabled', true);
                            $('.alert .msg-content').html('');
                            $('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true){
                                oTable.ajax.reload();
                                toastr.success(resp.message);
                            }else{
                                toastr.error(resp.message);
                            }
                        },
                        error: function (e) {
                            alert('Error: ' + e);
                        }
                    });
                }
            });
            
    });

    $("body").on("keyup", ".sequence_update", function () {
        // alert('set');
			var field = $(this).attr('field');
			var value = $(this).val();
			var row_id = $(this).attr('row_id');
            // alert(value);
			var obj = $(this);
			$.ajax({
				type: "POST",
				url: "{{url('admin/number/sequenceupdate')}}",
				data: {
					"_token": "{{ csrf_token() }}",
					"id": row_id,
					"sequence": value,
				},
				error: function (e) {
					if (e.status == 403) {
						alert('Unauthorized: Access is denied due to invalid credentials.');
					}else{
						alert('internal error occurred.');
					}
				},
				success: function (result) {
                    // data_table(page_url=false);
					$(obj).after('<span class="text-success txt_inline_notification">Saved</span>');
					$('.txt_inline_notification').delay(1000).fadeOut('slow');
					oTable.ajax.reload();
				}
			});
			
    });
		
});

</script>
@endsection