<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
}
</style>
    <div class="row">
		<div class="col-md-12">
			<div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
			<label for="name" class="form-label text-dark">Name <span class="text-danger">*</span></label>
				<input type="text" class="form-control" id="inputName" placeholder="Name" name="name" value="{{!empty($testimonial)?$testimonial->name:''}}" required>
			@error('name')
			<div style="color:red">{{ $message }}</div>
			@enderror
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group {{ $errors->has('designation') ? ' has-error' : '' }}">
			<label for="designation" class="form-label text-dark">Designation <span class="text-danger">*</span></label>
				<input type="text" class="form-control" id="designation" placeholder="designation" name="designation" value="{{!empty($testimonial)?$testimonial->designation:''}}" required>
			@error('designation')
			<div style="color:red">{{ $message }}</div>
			@enderror
			</div>
		</div>

		
		<div class="col-md-12">
			<div class="form-group {{ $errors->has('description') ? ' has-error' : '' }}">
				<label for="meta_tag" class="form-label">
					Description <span class="text-danger">*</span>
					<small class="text-muted">
						(Maximum <strong>200 characters</strong> allowed.)
						<span id="desc-count" class="text-primary">0/200</span>
					</small>
				</label>
				<textarea class="form-control"
					id="description"
					name="description"
					placeholder="Description"
					maxlength="200"
					required
					oninput="updateCount()">{{ !empty($testimonial) ? $testimonial->description : '' }}</textarea>

				@error('description')
					<div style="color:red">{{ $message }}</div>
				@enderror
			</div>
		</div>

		<div class="col-md-6">
			<div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
			<label for="firm_name" class="form-label text-dark">Upload  Image</label>
				<input type="file" class="form-control image-input" id="aadhar_image" data-preview="image" placeholder="Upload  Image" name="image" value="{{!empty($testimonial)?$testimonial->image:''}}" >
				<img class="form-group  image-preview" id="image" src="{{$testimonial?$testimonial->image_url:url('public/assets/admin/images/not-available (1).jpg')}}" style="width:150px;">
			@error('aadhar_image')
			<div style="color:red">{{ $message }}</div>
			@enderror
			</div>
		</div>
    </div>
@section('js')
<script>
function updateCount() {
	let desc = document.getElementById("description");
	let count = document.getElementById("desc-count");
	count.textContent = desc.value.length + "/200";
}

document.addEventListener("DOMContentLoaded", updateCount);
jQuery(function(e){
    'use strict';
    $(document).ready(function() {
        $('#description').summernote();
    });
  });
  
jQuery(document).ready(function () {
       
	jQuery('.image-input').on('change', function () {
		
		var file = this.files[0];
			var previewId = jQuery(this).data('preview');
			console.log(previewId);
		
		if (file) {   
			
			var reader = new FileReader();

			
			reader.onload = function (e) {
				
				jQuery('#' + previewId).attr('src', e.target.result);
			};

			
			reader.readAsDataURL(file);
		} else {
			
			jQuery('#' + previewId).attr('src', ''); 
		}
	});
});
  
  </script>

@endsection