@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Testimonial Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Testimonial Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/testimonial/create') }}"><button type="button" class="btn btn-primary">Add Testimonial</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Testimonials Details</h4>
                            <input type="hidden" id="status" value="{{$status}}">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive ">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="testimonialsDataTable">
                                <thead>
                                    <tr>
                                        <th ><span>SR</span></th>
                                        <th ><span>Name</span></th>
                                        <th ><span>Designation</span></th>
                                        <th ><span>Image</span></th>
                                        <th ><span>Status</span></th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
   jQuery(document).ready(function () {
    // $("#testimonialsDataTable").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    var status = $('#status').val();
    var oTable = $('#testimonialsDataTable').DataTable({
			responsive: true,
			autoWidth: false,
			stateSave: true,
			processing: true,
			serverSide: true,
			ajax:{ 
                url: "{{ url('admin/testimonial') }}",
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                    "status": status,
                },
             },
			columns: [
				{data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'name', name: 'name',orderable : false,className : 'text-center'},
                {data: 'designation', name: 'designation',orderable : false,className : 'text-center'},
				{ data: 'image', name: 'image', searchable: false,orderable : false },
				{ data: 'status', name: 'status', searchable: false,orderable : false },
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
    });

    $("body").on("change", "#statusToggle", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "you want to Deactivate this?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var currentStatus = jQuery(this).data('status');
                jQuery.ajax({
                    url: "{{ url('admin/testimonial') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.result == 1)
                        oTable.ajax.reload();
                        toastr.success(data.message);

                        jQuery('#statusToggle').data('status', data.status);
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });   
    });

    $("#testimonialsDataTable").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/testimonial')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
		
});

</script>
@endsection