@extends('admin.layout.app')

@section('content')
<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 50px;
    left: 178px;
}
</style>
<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Vendor Account Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Account Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
               
				  <!-- <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/vendor/create') }}"><button type="button" class="btn btn-primary">Add Vendor</button></a>
				 </div> -->
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Vendors Account Details</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive ">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th ><span>SR</span></th>
                                        <th ><span>Vendor</span></th>
                                        <th ><span>Order Id</span></th>
                                        <th ><span>Product Id</span></th>
                                        <th ><span>Payment Elegible</span></th>
                                        <th ><span>Payment Status</span></th>
                                        <th ><span>Payment Date</span></th>
                                        <th ><span>Remarks</span></th>
                                        <th ><span>Order Date</span></th>
                                        <th ><span>Order Payment Date</span></th>
                                        <!-- <th >Action</th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
   jQuery(document).ready(function () {
    // $("#example1").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
			ajax:{ 
                url: "{{ url('admin/vendoraccount') }}",
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                },
             },
			columns: [
				{data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'vendor.name', name: 'vendor.name',orderable : false,className : 'text-center'},
                {data: 'order_id', name: 'order_id',orderable : false,className : 'text-center'},
				{ data: 'product_id', name: 'product_id', searchable: false,orderable : false },
                {data: 'payment_elegible', name: 'payment_elegible',orderable : false,className : 'text-center'},
                {data: 'payment_status', name: 'payment_status',orderable : false,className : 'text-center'},
                {data: 'payment_date', name: 'payment_date',orderable : false,className : 'text-center'},
                {data: 'remarks', name: 'remarks',orderable : false,className : 'text-center'},
                {data: 'order_date', name: 'order_date',orderable : false,className : 'text-center'},
                {data: 'order_pay_date', name: 'order_pay_date',orderable : false,className : 'text-center'},
				// {data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
    });

    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/vendoraccount')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
		
});

</script>
@endsection