@extends('admin.layout.app')

@section('content')


<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Vendor Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    {{-- <a href="{{url('admin/vendorPaymentStatus')}}"  class="btn btn-primary">Update Status</a> --}}
                    <a href="#" id="updateStatusBtn" class="btn btn-primary">Update Status</a>

				 </div>
            </div> 
        </div>
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Vendor Details</h4>
                            <input type="hidden" id="vendor_id" value="{{$vendor_id}}">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR No</th>
                                        <th >Order Number</th>
                                        <th >Date</th>
                                        <th >Number</th>
                                        <th >Vendore Amount</th>
                                        <th >Payment Status</th>
                                        <th >Payment Date</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $sr = 1;
                                    @endphp
                                    @foreach($records as $record)
                                        <tr style=" @if($record->payment_status == 'C') color:red; @endif">
                                            <td >{{$sr}}</td>
                                            <td >{{$record->order_number}}</td>
                                            <td >{{$record->orderdetails_order_date}}</td>
                                            <td >{{$record->product_name}}</td>
                                            <td >{{$record->vendor_rate}}</td>
                                            <td >
                                                @if($record->payment_status == 'Y')
                                                    PAID
                                                @elseif($record->payment_status == 'N')
                                                    Pending
                                                @else
                                                    Cancelled
                                                @endif
                                            </td>
                                            <td >{{$record->payment_date}}</td>
                                            <td >
                                                @if($record->payment_elegible != 'N' && $record->payment_status != 'C')
                                                    <input type="checkbox" class="checkbox" name="checkbox_name" value="{{$record->id}}">
                                                @endif
                                            </td>
                                            @php
                                                $sr++;
                                            @endphp
                                        <tr>
                                    @endforeach
                                    </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('updateStatusBtn').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.checkbox:checked');
            var checkedValues = [];
            checkboxes.forEach(function(checkbox) {
                checkedValues.push(checkbox.value);
            });
            var queryString = checkedValues.join('&');
            var url = '{{url("admin/vendorPaymentStatus")}}?' + queryString;
            window.location.href = url;
        });
    });

 $(function () {
    $('#paymentDate').bootstrapdatepicker({
        autoclose: true,
        format: "yyyy-mm-dd",
        viewMode: "date",
    });
    
});
jQuery(document).ready(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"pageLength": 25,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    // var vendor_id = "{{request()->vendorid}}";
    // var oTable = $('#example1').DataTable({
    //         "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 2,
    //         "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
    //         processing: true,
    //         serverSide: true,
    //         dom:'lBfrtip',
    // 		ajax:{ 
    //             url: "{{ url('admin/vendorcredit') }}",
    //             type: 'get',
    //             data: {
    //                 "_token": "{{ csrf_token() }}",
    //                 "vendor_id": vendor_id,
    //             },
                
    //          },
    // 		columns: [
    //             { data: 'sr_no', name: 'sr_no', searchable: false, className: 'text-center' },
    //             { data: 'order_number', name: 'orderdetails.order_number', orderable: false, className: 'text-center' },
    //             { data: 'orderdetails_order_date', name: 'orderdetails.order_date', searchable: false, orderable: false, className: 'text-center' },
    //             { data: 'product_name', name: 'orderdetails.product_name', defaultContent: '-', orderable: false, className: 'text-center' },
    //             { data: 'vendor_rate', name: 'orderdetails.vendor_rate', searchable: false, orderable: false, className: 'text-center' }, 
    //             { data: 'payment_status', name: 'vendor_accounts.payment_status', searchable: false, orderable: false, className: 'text-center' },
    //             { data: 'payment_date', name: 'vendor_accounts.payment_date', searchable: false, orderable: false, className: 'text-center' }, 
    //             { data: 'action', name: 'action', searchable: false, orderable: false, className: 'text-center' },
    // 		],
    //         "createdRow": function (row, data, index) {
    //             if (data.payment_status == "Cancelled") {
    //                 $(row).css('color', 'red'); 
    //             }
    //         }
    // });
   
 


});

</script>
@endsection