@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">      
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Wishlist List</h4>
                    <span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Wishlist List</span>
                </div>
            </div>
           <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="{{request()->startDate}}" />
                        <input type="hidden" name="endDate" id="endDate" value="{{request()->endDate}}" />
                    </div>
                </div>
				 
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Wishlist List</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >Sr No</th>
                                        <th >Name</th>
                                        <th >Contact No.</th>
                                        <th >Email</th>
                                        <th >Product</th>
                                        <th >Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
						
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Customer Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div id="customer_detail_append"></div>
        </div>
        <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>


@endsection
@section('js')
<script>
jQuery(document).ready(function () {
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
            ajax:{ 
                url: "{{ url('admin/wishlist') }}",
                type: 'get',
                data: function (d) {
                    d._token = "{{ csrf_token() }}";
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();
                    d.search = {
                        value: $('input[type="search"]').val()  
                    };
                },
                
                },
            columns: [
                {data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'full_name', name: 'full_name',searchable: false,orderable : false,className : 'text-center'},
                {data: 'mobile', name: 'mobile', searchable: true,orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'email', name: 'email', searchable: true,orderable : false,className : 'text-center'},
                {data: 'product', name: 'product', searchable: true,orderable : false,className : 'text-center'},
                {data: 'created_at', name: 'created_at', searchable: true,orderable : false,className : 'text-center'},
            ]
            
    });
});

$(function () {    	 
    var start = moment().subtract(29, 'days');
        var end = moment();
        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, 
        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
        }
        )
});
		

</script>
@endsection