@extends('user.layout.sub-app')
@section('title', 'Contact | Extrutech Hardware')

@php
    $seo = [
        'title' => 'Contact Extrutech Hardware',
        'description' => 'Get in touch with Extrutech Hardware for inquiries about profiles, hardware, and architectural solutions.',
        'keywords' => 'contact extrutech, hardware inquiries, hardware support, architectural hardware contact',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
@endphp
@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection


@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "{{ $sitesetting->comp_name ?? 'Extrutech Hardware' }}",
  "url": "{{ url('/') }}",
  "logo": "{{ asset('assets/user/img/seo/contact-banner.jpg') }}",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "{{ $sitesetting->comp_address ?? '' }}"
  },
  "telephone": [
    "{{ $sitesetting->comp_phone ?? '' }}",
    "{{ $sitesetting->comp_phone2 ?? '' }}"
  ],
  "email": [
    "{{ $sitesetting->comp_email ?? '' }}",
    "{{ $sitesetting->comp_email2 ?? '' }}"
  ]
}
</script>
@endsection

@section('content')
    <!-- Breadcrumb -->
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name">Contact Us</h1>
                    <ul class="breadcumb-menu">
                        <li class="wow fadeInUp" data-wow-delay=".2s" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li class="wow fadeInUp" data-wow-delay=".3s" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">Contact</span>
                            <meta itemprop="position" content="2" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Info -->
    <div class="space" itemscope itemtype="https://schema.org/Organization">
        <div class="container">
            <div class="row gy-4">

                <!-- Location -->
                @if($sitesetting->comp_address)
                    <div class="col-xl-4 col-md-6" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
                        <div class="contact-media">
                            <div class="icon-btn"><i class="fa-solid fa-location-dot"></i></div>
                            <div class="media-body">
                                <h5 class="box-title">Our Current Location</h5>
                                <p class="box-text" itemprop="streetAddress">{{ $sitesetting->comp_address }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Phone Numbers -->
                @if($sitesetting->comp_phone || $sitesetting->comp_phone2)
                    <div class="col-xl-4 col-md-6">
                        <div class="contact-media">
                            <div class="icon-btn"><i class="fa-solid fa-phone"></i></div>
                            <div class="media-body">
                                <h5 class="box-title">Phone Number</h5>
                                <p class="box-text">
                                    @if($sitesetting->comp_phone)
                                        <a href="tel:{{ $sitesetting->comp_phone }}" itemprop="telephone">{{ $sitesetting->contact_phone_name1 ?? $sitesetting->comp_phone }}</a><br>
                                    @endif
                                    @if($sitesetting->comp_phone2)
                                        <a href="tel:{{ $sitesetting->comp_phone2 }}" itemprop="telephone">{{ $sitesetting->contact_phone_name2 ?? $sitesetting->comp_phone2 }}</a>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Email Addresses -->
                @if($sitesetting->comp_email || $sitesetting->comp_email2)
                    <div class="col-xl-4 col-md-6">
                        <div class="contact-media">
                            <div class="icon-btn"><i class="fa-solid fa-envelope"></i></div>
                            <div class="media-body">
                                <h5 class="box-title">Email Address</h5>
                                <p class="box-text">
                                    @if($sitesetting->comp_email)
                                        <a href="mailto:{{ $sitesetting->comp_email }}" itemprop="email">{{ $sitesetting->comp_email }}</a>
                                        @if($sitesetting->comp_email2)<br>@endif
                                    @endif
                                    @if($sitesetting->comp_email2)
                                        <a href="mailto:{{ $sitesetting->comp_email2 }}" itemprop="email">{{ $sitesetting->comp_email2 }}</a>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>

    <!-- Contact Form Section -->
    <div class="contact-area overflow-hidden space" id="contact-sec">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact" itemscope itemtype="https://schema.org/ContactPage">
                        <div class="title-area">
                            <span class="sub-title style2 text-anime">get in touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into Reality</h2>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <input type="text" class="form-control" name="name" id="name" placeholder="Full Name" required> 
                                <i class="fa-solid fa-user"></i>
                            </div>
                            <div class="form-group col-md-6">
                                <input type="email" class="form-control" name="email" id="email" placeholder="Email Address" required> 
                                <i class="fa-solid fa-envelope"></i>
                            </div>
                            <div class="form-group col-md-6">
                                <input type="tel" class="form-control" name="number" id="number" placeholder="Phone Number" required> 
                                <i class="fa-solid fa-phone"></i>
                            </div>
                            <div class="form-group col-md-6">
                                <select name="subject" id="subject" class="form-select nice-select" required>
                                    <option value="" disabled selected hidden>Inquire Services</option>
                                    <option value="Interior Consulting">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select>
                            </div>
                            <div class="form-group col-12">
                                <textarea name="message" id="message" cols="30" rows="3" class="form-control" placeholder="Your Message" required></textarea> 
                                <i class="fa-solid fa-comment"></i>
                            </div>
                            <div class="col-12 form-group">
                                <input type="checkbox" id="html" required> 
                                <label for="html">I agree with the privacy policy</label>
                            </div>
                            <div class="form-btn mt-20 col-12">
                                <button class="th-btn">Send Message</button>
                            </div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image">
                        <div class="img1 img-anim-left"><img src="{{ asset('assets/user/img/normal/contact-img-1.jpg') }}" alt=""></div>
                        <div class="img2 img-anim-right"><img src="{{ asset('assets/user/img/normal/contact-img-2.jpg') }}" alt=""></div>
                        <div class="img3 img-anim-left"><img src="{{ asset('assets/user/img/normal/contact-img-3.jpg') }}" alt=""></div>
                        <div class="img4 img-anim-right"><img src="{{ asset('assets/user/img/normal/contact-img-4.jpg') }}" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="shape-mockup spin d-none d-xxl-block" data-top="12%" data-right="13%"><img src="{{ asset('assets/user/img/shape/element-6.png') }}" alt=""></div>
    </div>

    <!-- Google Map -->
    <div class="">
        <div class="contact-map">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3644.7310056272386!2d89.2286059153658!3d24.00527418490799!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39fe9b97badc6151%3A0x30b048c9fb2129bc!2sAngfuztheme!5e0!3m2!1sen!2sbd!4v1651028958211!5m2!1sen!2sbd" allowfullscreen="" loading="lazy"></iframe>
            <div class="contact-icon"><img src="{{ asset('assets/user/img/icon/location-dot.svg') }}" alt=""></div>
        </div>
    </div>
@endsection
