@extends('user.layout.sub-app')

@section('title', 'Gallery | Extrutech Hardware')

@php
    $seo = [
        'title' => 'Extrutech Hardware | Project Photo Gallery',
        'description' => 'Explore our profile and hardware installation photo gallery.',
        'keywords' => 'gallery, interior design, profile gallery',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
@endphp

@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection


@section('content')

<div class="overflow-hidden space" id="project-sec">
    <div class="container">

        {{-- Filter Menu --}}
        <div class="row justify-content-center">
            <div class="col-xl-7">
                <div class="filter-menu indicator-active mb-60 filter-menu-active">
                    <button data-filter="*" class="tab-btn active" type="button">View All</button>
                    <button data-filter=".cat1" class="tab-btn" type="button">Interior</button>
                    <button data-filter=".cat2" class="tab-btn" type="button">Architecture</button>
                    <button data-filter=".cat3" class="tab-btn" type="button">Building</button>
                    <button data-filter=".cat4" class="tab-btn" type="button">Exterior</button>
                    <button data-filter=".cat5" class="tab-btn" type="button">Shape</button>
                </div>
            </div>
        </div>

        {{-- Gallery Items --}}
        <div class="row gy-4 gallery-row filter-active">

            <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat2 cat5">
                <div class="gallery-card">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/gallery/gallery_2_1.jpg') }}" 
                             alt="Open Kitchen Interior Design" 
                             title="Open Kitchen Interior Design" 
                             loading="lazy">
                        <a href="{{ asset('assets/user/img/gallery/gallery_2_1.jpg') }}" class="icon-btn th-popup-image">
                            <i class="far fa-plus"></i>
                        </a>
                        <div class="shape">
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                        </div>
                    </div>
                    <div class="gallery-content">
                        <h2 class="box-title">Open Kitchen Interior Design</h2>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat3 cat2">
                <div class="gallery-card">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/gallery/gallery_2_2.jpg') }}" 
                             alt="Open Kitchen Interior Design" 
                             title="Open Kitchen Interior Design" 
                             loading="lazy">
                        <a href="{{ asset('assets/user/img/gallery/gallery_2_2.jpg') }}" class="icon-btn th-popup-image">
                            <i class="far fa-plus"></i>
                        </a>
                        <div class="shape">
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                        </div>
                    </div>
                    <div class="gallery-content">
                        <h2 class="box-title">Open Kitchen Interior Design</h2>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat3 cat5">
                <div class="gallery-card">
                    <div class="box-img global-img">
                        <img src="{{ asset('assets/user/img/gallery/gallery_2_3.jpg') }}" 
                             alt="Open Kitchen Interior Design" 
                             title="Open Kitchen Interior Design" 
                             loading="lazy">
                        <a href="{{ asset('assets/user/img/gallery/gallery_2_3.jpg') }}" class="icon-btn th-popup-image">
                            <i class="far fa-plus"></i>
                        </a>
                        <div class="shape">
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                        </div>
                    </div>
                    <div class="gallery-content">
                        <h2 class="box-title">Open Kitchen Interior Design</h2>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</div>

@endsection
