@php
    $categories = App\Models\Category::where('status', 'Active')->orderBy('name')->get();
@endphp
<div class="cursor"></div>
<div class="cursor2"></div>

<!-- Preloader -->
<div class="loader-wrap">
    <svg viewBox="0 0 1000 1000" preserveAspectRatio="none">
        <path id="svg" d="M0,1005S175,995,500,995s500,5,500,5V0H0Z"></path>
    </svg>
    <div class="loader-wrap-heading">
        <div class="load-text">
            <span>L</span><span>o</span><span>a</span><span>d</span><span>i</span><span>n</span><span>g</span>
        </div>
    </div>
</div>

<!-- Mobile Menu Wrapper -->
<div class="th-menu-wrapper">
    <div class="th-menu-area text-center">
        <button class="th-menu-toggle">
            <i class="fal fa-times"></i>
        </button>
        <div class="mobile-logo">
            <a href="{{ url('/') }}">
                <img src="{{ asset('assets/user/img/extrutech.png') }}" alt="Faren">
            </a>
        </div>
        <div class="th-mobile-menu">
            <ul>
                <li><a href="{{ url('/') }}">Home</a></li>
                <li><a href="{{ url('/about') }}">About</a></li>
                <li><a href="{{ url('/services') }}">Services</a></li>
                <li class="has-submenu">
                    <a href="javascript:void(0)" class="mobile-trigger">
                        Products <span class="arrow">+</span>
                    </a>
                    <ul class="submenu">
                        @forelse($categories as $category)
                            <li>
                                <a href="{{ url('/products/' . $category->slug) }}">{{ $category->name }}</a>
                            </li>
                        @empty
                            <li><a href="#">No categories found</a></li>
                        @endforelse
                    </ul>
                </li>
                <li><a href="{{ url('/gallery') }}">Gallery</a></li>
                <li><a href="{{ url('/blog') }}">Blog</a></li>
                <li><a href="{{ url('/contact') }}">Contact</a></li>
                <li><a href="{{ url('/brochure') }}">Brochure</a></li>
            </ul>
        </div>
    </div>
</div>

<!-- Main Header -->
<header class="th-header header-layout7 header-absolute">
    <div class="sticky-wrapper">
        <div class="container th-container4">
            <div class="menu-area">
                <div class="row align-items-center justify-content-between">
                    <!-- Logo -->
                    <div class="col-auto">
                       <div class="header-logo">
                            <a href="{{ url('/') }}" title="Extrutech Hardware – Premium Aluminium Architectural Hardware & Profiles">
                                <img src="{{ asset('assets/user/img/logo-2.png') }}"
                                    alt="Extrutech Hardware Logo – Aluminium Architectural Hardware Manufacturer"
                                    title="Extrutech Hardware – Trusted Aluminium Hardware & Profiles Manufacturer">
                            </a>
                        </div>

                    </div>

                    <!-- Desktop Menu -->
                    <div class="col-auto">
                        <nav class="main-menu d-none d-lg-inline-block">
                            <ul>
                                <li><a href="{{ url('/') }}">Home</a></li>
                                <li><a href="{{ url('/about') }}">About</a></li>
                                <li><a href="{{ url('/services') }}">Services</a></li>
                                <li class="has-submenu">
                                    <a href="javascript:void(0)">Products</a>
                                    <ul class="submenu">
                                        @forelse($categories as $category)
                                            <li>
                                                <a href="{{ url('/products/' . $category->slug) }}">{{ $category->name }}</a>
                                            </li>
                                        @empty
                                            <li><a href="#">No categories found</a></li>
                                        @endforelse
                                    </ul>
                                </li>
                                <li><a href="{{ url('/gallery') }}">Gallery</a></li>
                                <li><a href="{{ url('/blog') }}">Blog</a></li>
                                <li><a href="{{ url('/brochure') }}">Brochure</a></li>
                            </ul>
                        </nav>
                    </div>

                    <!-- Header Buttons -->
                    <div class="col-auto">
                        <!-- Desktop Buttons -->
                        <div class="header-button d-none d-lg-flex">
                            <a href="{{ url('/contact') }}" class="th-btn white-border">Get Free Consultant</a>
                            <button type="button" class="icon-btn sideMenuToggler d-none d-lg-block">
                                <i class="fa-regular fa-bars"></i>
                            </button>
                        </div>

                        <!-- Mobile Menu Toggle -->
                        <div class="header-button">
                            <button type="button" class="th-menu-toggle d-inline-block d-lg-none">
                                <i class="far fa-bars"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>