@extends('user.layout.sub-app')
@section('title', 'Our Products | Extrutech Hardware')
@php
    $seo = [
        'title' => 'Extrutech Hardware',
        'description' => 'Extrutech Hardware.',
        'keywords' => 'products, extrutech, hardware',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
@endphp

@section('meta')
<meta property="og:type" content="website">
<meta property="og:title" content="{{ $seo['title'] }}">
<meta property="og:description" content="{{ $seo['description'] }}">
<meta property="og:image" content="{{ $seo['image'] }}">
<meta property="og:url" content="{{ $seo['canonical'] }}">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $seo['title'] }}">
<meta name="twitter:description" content="{{ $seo['description'] }}">
<meta name="twitter:image" content="{{ $seo['image'] }}">
@endsection


@section('schema')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "CollectionPage",
  "name": "Extrutech Hardware Products",
  "description": "Explore aluminium architectural hardware & profiles.",
  "url": "{{ url()->current() }}",
  "image": "{{ asset('img/seo/home-banner.jpg') }}"
}
</script>
@endsection

@section('content')
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/user/img/bg/breadcumb-bg.jpg') }}">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name">{{ $category->name }}</h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="{{ url('/') }}" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">Products</span>
                            <meta itemprop="position" content="2" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">{{ $category->name }}</span>
                            <meta itemprop="position" content="3" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <section class="space-top space-extra-bottom">
        <div class="container">
            <div class="row gy-4">
                @forelse($products as $product)
                    <div class="col-xl-4 col-md-6">
                        <div class="th-product product-grid">
                            <div class="product-img">
                                <a href="{{ route('productdetails', [$category->slug, $product->slug]) }}">
                                    <img src="{{ $product->image ? asset($product->image) : 'https://via.placeholder.com/400x400.png?text=No+Image' }}"
                                        alt="{{ $product->name }}" title="{{ $product->name }}" class="img-fluid">
                                </a>
                            </div>
                            <div class="product-content">
                                <h2 class="product-title">
                                    <a href="{{ route('productdetails', [$category->slug, $product->slug]) }}">
                                        {{ $product->name }}
                                    </a>
                                </h2>
                                <p class="box-text">
                                    {!! Str::limit(strip_tags($product->description), 400) !!}
                                </p>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12 text-center py-5">
                        <p class="text-muted fs-18">No products available at the moment.</p>
                    </div>
                @endforelse

            </div>

            @if($products->hasPages())
                <div class="th-pagination text-center mt-60">
                    {{ $products->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </section>
@endsection
