<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\UserAuth\HomeController;
use App\Http\Controllers\UserAuth\AboutController;
use App\Http\Controllers\UserAuth\GalleryController;
use App\Http\Controllers\UserAuth\ProductsController;
use App\Http\Controllers\UserAuth\ServicesController;
use App\Http\Controllers\UserAuth\ContactController;
use App\Http\Controllers\UserAuth\BlogController;
use App\Http\Controllers\UserAuth\BrochureController;


Route::controller(HomeController::class)->group(function() {
    Route::get('/', 'home')->name('home');
    Route::get('/forecast-details/{slug}', 'forecastdetails')->name('forecastdetails');

});
Route::get('/about', [AboutController::class, 'index'])->name('about');
Route::get('/gallery', [GalleryController::class, 'index'])->name('gallery');
Route::get('/products/{slug}', [ProductsController::class, 'index'])->name('products');
Route::get('/products/{category_slug}/{product_slug}', [ProductsController::class, 'productdetails'])->name('productdetails');
Route::get('/services', [ServicesController::class, 'index'])->name('services');
Route::get('/service-detail/{slug}', [ServicesController::class, 'servicedetail'])->name('servicedetail');
Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::get('/blog', [BlogController::class, 'index'])->name('blog');
Route::get('/brochure', [BrochureController::class, 'index'])->name('brochure');



Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    return "Cache cleared!";
});