<?php $__env->startSection('title', 'All Blogs | Extrutech Hardware'); ?>

<?php
    $seo = [
        'title' => 'All Blogs | Extrutech Hardware',
        'description' => 'Read the latest news, insights, and architectural solutions from Extrutech Hardware.',
        'keywords' => 'blogs, extrutech news, architectural hardware tips',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url()->current()
    ];
?>

<?php $__env->startSection('meta'); ?>
<meta property="og:type" content="website">
<meta property="og:title" content="<?php echo e($seo['title']); ?>">
<meta property="og:description" content="<?php echo e($seo['description']); ?>">
<meta property="og:image" content="<?php echo e($seo['image']); ?>">
<meta property="og:url" content="<?php echo e($seo['canonical']); ?>">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($seo['title']); ?>">
<meta name="twitter:description" content="<?php echo e($seo['description']); ?>">
<meta name="twitter:image" content="<?php echo e($seo['image']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('schema'); ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Blog",
  "name": "Extrutech Hardware Blog",
  "url": "<?php echo e(url()->current()); ?>",
  "description": "<?php echo e($seo['description']); ?>",
  "publisher": {
    "@type": "Organization",
    "name": "Extrutech Hardware",
    "logo": {
      "@type": "ImageObject",
      "url": "<?php echo e(asset('assets/user/img/extrutech.png')); ?>"
    }
  }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
    <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
        <div class="container">
            <div class="breadcumb-content">
                <h1 class="breadcumb-title text-anime" itemprop="name">All Blogs</h1>
                <ul class="breadcumb-menu">
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <a href="<?php echo e(url('/')); ?>" itemprop="item"><span itemprop="name">Home</span></a>
                        <meta itemprop="position" content="1" />
                    </li>
                    <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name">All Blogs</span>
                        <meta itemprop="position" content="2" />
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="th-blog-wrapper py-5">
    <div class="container">
        <div class="row g-4">
            <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-lg-6 col-xl-4">
                <div class="th-blog blog-single has-post-thumbnail single-grid">
                    <div class="blog-img global-img">
                        <a href="javascript:void(0)">
                            <img src="<?php echo e($blog->image ? asset($blog->image) : 'https://via.placeholder.com/400x300.png?text=No+Image'); ?>" 
                                 alt="<?php echo e($blog->name); ?>" title="<?php echo e($blog->name); ?>" class="img-fluid">
                        </a>
                    </div>
                    <div class="blog-content">
                        <h2 class="box-title">
                            <a href="javascript:void(0)"><?php echo e($blog->name); ?></a>
                        </h2>
                        <p class="box-text">
                            <?php echo Str::limit(strip_tags($blog->description), 120); ?>

                        </p>
                        <div class="blog-date mt-2">
                            <span class="date"><?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d')); ?></span> 
                            <span class="month"><?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('M Y')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center py-5">
                <p class="text-muted fs-18">No blogs available at the moment.</p>
            </div>
            <?php endif; ?>
        </div>

        <?php if($blogs->hasPages()): ?>
        <div class="th-pagination text-center mt-30">
            <?php echo e($blogs->links('pagination::bootstrap-5')); ?>

        </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.sub-app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/blog.blade.php ENDPATH**/ ?>