<?php $sitesetting = App\Models\Sitesetting::first();  ?>
<?php $__env->startSection('meta'); ?>
  <meta name="description" content="<?php echo e($sitesetting->meta_desc); ?>" />
  <meta name="keywords" content="<?php echo e($sitesetting->meta_keyword); ?>" />
  <meta name="author" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="<?php echo e(url('/')); ?>" />
  <meta property="og:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta property="og:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta property="og:url" content="<?php echo e(url('/')); ?>" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="twitter:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
<?php $__env->stopSection(); ?>
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "<?php echo e($sitesetting->comp_name ?? 'Pandit Chirag Guruji'); ?>",
    "url": "<?php echo e(url('/')); ?>",
    "logo": "<?php echo e(asset($sitesetting->image ?? '')); ?>",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": <?php echo e($sitesetting->comp_phone); ?>,
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo e(strip_tags($sitesetting->comp_address ?? '')); ?>",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "<?php echo e(url('/')); ?>"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "<?php echo e(url('/')); ?>/services"
        }
      ]
    }
  }
</script>



<?php $__env->startSection('pagetitle'); ?>
  <title><?php echo e($sitesetting->comp_name); ?> | Contact Us</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- partial:partia/__subheader.html -->
  <div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url(<?php echo e(asset('assets/user/images/subheader.jpg')); ?>)">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Contact Us</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="#">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>
  <!-- partial -->

  <!-- Map Start -->
  <div class="sigma_map">
    <iframe
        width="100%"
        height="100%"
        frameborder="0"
        style="border:0;"
        src="https://www.google.com/maps?q=<?php echo e(urlencode($sitesetting->comp_address)); ?>&output=embed"
        allowfullscreen>
    </iframe>
  </div>
  <!-- Map End -->

  

  <!-- Icons Start -->
  <div class="section section-padding">
    <div class="container">
      <div class="row equal-height">

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-email"></i>
            <div>
              <div class="sigma_icon-block-content">
                <span>Send Email <i class="far fa-arrow-right"></i> </span>
                <h5> Email Address</h5>
                <?php if(!empty($sitesetting->comp_email)): ?>
                    <span>
                        <a href="mailto:<?php echo e($sitesetting->comp_email); ?>" style="color: inherit; text-decoration: none;">
                            <?php echo e($sitesetting->comp_email); ?>

                        </a>
                    </span>
                <?php endif; ?>
              </div>
              <div class="icon-wrapper">
                <i class="flaticon-email"></i>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-call"></i>
            <div class="sigma_icon-block-content">
              <span>Call Us Now <i class="far fa-arrow-right"></i> </span>
              <h5> Phone Number </h5>
              <?php if(!empty($sitesetting->comp_phone)): ?>
                  <span>
                      <a href="tel:+91<?php echo e($sitesetting->comp_phone); ?>" style="color: inherit; text-decoration: none;">
                          <i class="fas fa-phone-alt"></i>+91 <?php echo e($sitesetting->comp_phone); ?>

                      </a>
                  </span>
              <?php endif; ?>
              <div class="icon-wrapper">
                <i class="flaticon-call"></i>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-location"></i>
            <div class="sigma_icon-block-content">
              <span>Find Us Here <i class="far fa-arrow-right"></i> </span>
              <h5> Location </h5>
              <?php if(!empty($sitesetting->comp_address)): ?>
                  <span class="address-text"><?php echo $sitesetting->comp_address; ?></span>
              <?php endif; ?>
              <div class="icon-wrapper">
                <i class="flaticon-location"></i>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <!-- Icons End -->


<?php $__env->stopSection(); ?>


<?php echo $__env->make('user.layout.subapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/panditchiragguru/public_html/resources/views/user/contact.blade.php ENDPATH**/ ?>