<?php $__env->startSection('title', 'Our Services | Extrutech Hardware'); ?>

<?php
    $seo = [
        'title' => 'Extrutech Hardware | Services',
        'description' => 'Explore our hardware services, including profiles, fittings, and custom solutions for residential and commercial projects.',
        'keywords' => 'hardware services, glass fittings, profiles, custom hardware solutions, Extrutech Hardware',
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
?>
<?php $__env->startSection('meta'); ?>
<meta property="og:type" content="website">
<meta property="og:title" content="<?php echo e($seo['title']); ?>">
<meta property="og:description" content="<?php echo e($seo['description']); ?>">
<meta property="og:image" content="<?php echo e($seo['image']); ?>">
<meta property="og:url" content="<?php echo e($seo['canonical']); ?>">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($seo['title']); ?>">
<meta name="twitter:description" content="<?php echo e($seo['description']); ?>">
<meta name="twitter:image" content="<?php echo e($seo['image']); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('schema'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name">Our Services</h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="<?php echo e(url('/')); ?>" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">All Services</span>
                            <meta itemprop="position" content="2" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <section class="overflow-hidden space overflow-hidden" id="service-sec">
        <div class="container">
            <div class="row gy-5 justify-content-center">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-xl-4">
                        <div class="service-box wow fadeInUp" data-wow-delay=".1s">
                            <div class="box-img global-img">
                                <img src="<?php echo e(asset($service->image)); ?>" alt="<?php echo e($service->name); ?>">
                            </div>
                            <div class="box-content">
                                <h3 class="box-title">
                                    <a href="<?php echo e(route('servicedetail', $service->slug)); ?>"><?php echo e($service->name); ?></a>
                                </h3>
                                <p class="box-text"><?php echo \Illuminate\Support\Str::limit(strip_tags($service->description), 120); ?></p>
                                <a href="<?php echo e(route('servicedetail', $service->slug)); ?>" class="line-btn">More Information</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
   
    <div class="marquee-area2 overflow-hidden">
        <div class="marquee-content positive-relative overflow-hidden">
            <div class="marquee">
                <div class="marquee-group style2">
                    <?php $__currentLoopData = [
                        'Bright Halls',
                        'Sustainable Architecture',
                        'Landscape Architecture',
                        'Commercial Spa'
                    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <img src="<?php echo e(asset('assets/user/img/icon/star3.svg')); ?>" alt="Service Highlight Star" title="Service Highlight Star">
                            <a href="javascript:void(0)" target="_blank" data-hover="<?php echo e($item); ?>" title="<?php echo e($item); ?>"><?php echo e($item); ?></a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div aria-hidden="true" class="marquee-group style2">
                    <?php $__currentLoopData = [
                        'Bright Halls',
                        'Sustainable Architecture',
                        'Landscape Architecture',
                        'Commercial Spa'
                    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <img src="<?php echo e(asset('assets/user/img/icon/star3.svg')); ?>" alt="Service Highlight Star" title="Service Highlight Star">
                            <a href="javascript:void(0)" target="_blank" data-hover="<?php echo e($item); ?>" title="<?php echo e($item); ?>"><?php echo e($item); ?></a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <section class="position-relative overflow-hidden space-top overflow-hidden">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xl-6">
                    <div class="title-area">
                        <span class="sub-title style2 text-anime">Our services</span>
                        <h2 class="sec-title split-text">What we do</h2>
                    </div>
                </div>
                <div class="col-lg-6">
                    <p class="fs-18 wow fadeInUp">
                        We specialize in residential interiors, commercial spaces, and custom furniture design — creating cohesive & livable spaces from concept to completion.
                    </p>
                </div>
            </div>

            
            <div class="service-list-area">
                <?php
                    $services = [
                        ['num' => '01', 'title' => 'Architecture', 'img1' => 'ser_1_1.jpg', 'img2' => 'ser_1.jpg'],
                        ['num' => '02', 'title' => 'Interior Design', 'img1' => 'ser_1_2.jpg', 'img2' => 'ser_2.jpg'],
                        ['num' => '03', 'title' => 'Project Management', 'img1' => 'ser_1_3.jpg', 'img2' => 'ser_3.jpg'],
                        ['num' => '04', 'title' => 'Furniture Design', 'img1' => 'ser_1_4.jpg', 'img2' => 'ser_4.jpg'],
                        ['num' => '05', 'title' => 'Exterior Design', 'img1' => 'ser_1_5.jpg', 'img2' => 'ser_5.jpg'],
                    ];
                ?>

                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="service-list hover-item <?php echo e($loop->first ? 'item-active' : ''); ?>">
                        <div class="service-img">
                            <img src="<?php echo e(asset('assets/user/img/service/' . $service['img1'])); ?>" 
                                alt="<?php echo e($service['title']); ?> Service Banner" 
                                title="<?php echo e($service['title']); ?> Service">
                        </div>

                        <div class="service-img2">
                            <img src="<?php echo e(asset('assets/user/img/service/' . $service['img2'])); ?>" 
                                alt="<?php echo e($service['title']); ?> Preview" 
                                title="<?php echo e($service['title']); ?> Design Preview">
                        </div>

                        <div class="service-list-content">
                            <div class="service-wrapp">
                                <span class="number"><?php echo e($service['num']); ?>.</span>
                                <h3 class="box-title">
                                    <a href="javascript:void(0)" title="<?php echo e($service['title']); ?>"><?php echo e($service['title']); ?></a>
                                </h3>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div class="shape-mockup spin d-none d-xxl-block" data-top="26%" data-right="6%">
            <img src="<?php echo e(asset('assets/user/img/shape/element-5.png')); ?>" alt="Decorative Shape" title="Decorative Design Shape">
        </div>
    </section>
    <div class="contact-area overflow-hidden space overflow-hidden" id="contact-sec">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact">
                        <div class="title-area"><span class="sub-title style2 text-anime">get in touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into
                                Reality</h2>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6"><input type="text" class="form-control" name="name"
                                    id="name" placeholder="Full Name"> <i class="fa-solid fa-user"></i></div>
                            <div class="form-group col-md-6"><input type="email" class="form-control" name="email"
                                    id="email" placeholder="Email Address"> <i class="fa-solid fa-envelope"></i></div>
                            <div class="form-group col-md-6"><input type="tel" class="form-control" name="number"
                                    id="number" placeholder="Phone Number"> <i class="fa-solid fa-phone"></i></div>
                            <div class="form-group col-md-6"><select name="subject" id="subject"
                                    class="form-select nice-select">
                                    <option value="" disabled="disabled" selected="selected" hidden>Inquire Services
                                    </option>
                                    <option value="Interior Consultingt">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select></div>
                            <div class="form-group col-12"><textarea name="message" id="message" cols="30" rows="3"
                                    class="form-control" placeholder="Your Message"></textarea> <i
                                    class="fa-solid fa-comment"></i></div>
                            <div class="col-12 form-group"><input type="checkbox" id="html"> <label for="html">I agree
                                    with the privacy policy</label></div>
                            <div class="form-btn mt-20 col-12"><button class="th-btn">Send Message</button></div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image">
                        <div class="img1 img-anim-left">
                            <img src="<?php echo e(asset('assets/user/img/normal/contact-img-1.jpg')); ?>" 
                                alt="Luxury Interior Architecture Design Contact Image"
                                title="Luxury Interior Architecture Design Contact">
                        </div>

                        <div class="img2 img-anim-right">
                            <img src="<?php echo e(asset('assets/user/img/normal/contact-img-2.jpg')); ?>" 
                                alt="Premium Modern Interior Contact Illustration"
                                title="Premium Modern Interior Contact Picture">
                        </div>

                        <div class="img3 img-anim-left">
                            <img src="<?php echo e(asset('assets/user/img/normal/contact-img-3.jpg')); ?>" 
                                alt="Residential Interior Contact Visual"
                                title="Residential Interior Contact Display">
                        </div>

                        <div class="img4 img-anim-right">
                            <img src="<?php echo e(asset('assets/user/img/normal/contact-img-4.jpg')); ?>" 
                                alt="Commercial Interior Design Contact Theme"
                                title="Commercial Interior Design Contact">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="shape-mockup spin d-none d-xxl-block" data-top="12%" data-right="13%">
            <img src="<?php echo e(asset('assets/user/img/shape/element-6.png')); ?>"
                alt="Decorative Shape Element"
                title="Modern Decorative Design Shape">
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.sub-app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/services.blade.php ENDPATH**/ ?>