<?php $__env->startSection('title', 'Our Products | Extrutech Hardware'); ?>
<?php
    $seo = [
        'title' => 'Extrutech Hardware | Buy Premium Aluminium Profiles',
        'description' => 'Buy high-quality aluminium architectural hardware & profiles.',
        'keywords' => 'aluminium hardware, extrutech, glass hardware',
        'image' => asset('img/seo/home-banner.jpg'),
        'robots' => 'INDEX,FOLLOW'
    ];
?>

<?php $__env->startSection('content'); ?>
    <!-- Breadcrumb -->
    <div class="breadcumb-area">
        <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime">Product List</h1>
                    <ul class="breadcumb-menu">
                        <li class="wow fadeInUp" data-wow-delay=".2s"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="wow fadeInUp" data-wow-delay=".3s">Product List</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="breadcumb-shape ShapeAni" data-bg-src="img/shape/scale.png"></div>
    </div>
    <section class="space-top space-extra-bottom">
        <div class="container">
            <div class="row gy-4">

                <?php $__empty_1 = true; $__currentLoopData = $products->where('status', 'Active'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php if($product->name): ?> <!-- Sirf name wala product dikhao -->
                        <div class="col-xl-4 col-md-6">
                            <div class="th-product product-grid">
                                <div class="product-img">
                                    <img src="<?php echo e($product->image ? asset($product->image) : 'https://via.placeholder.com/400x400.png?text=No+Image'); ?>"
                                        alt="<?php echo e($product->name); ?>"
                                        class="img-fluid">
                                </div>
                                <div class="product-content">
                                    <h3 class="product-title">
                                        <a href="<?php echo e(url('/product/' . $product->slug)); ?>">
                                            <?php echo e($product->name); ?>

                                        </a>
                                    </h3>
                                    <p class="box-text">
                                        <?php echo Str::limit(strip_tags($product->description), 400); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12 text-center py-5">
                        <p class="text-muted fs-18">No products available at the moment.</p>
                    </div>
                <?php endif; ?>

            </div>

            <!-- Pagination (Laravel Default Style) -->
            <?php if($products->hasPages()): ?>
                <div class="th-pagination text-center mt-60">
                    <?php echo e($products->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- Agar koi custom JS hai to yahan add karna -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/product.blade.php ENDPATH**/ ?>