<?php $sitesetting = App\Models\Sitesetting::first();  ?>
<?php $__env->startSection('meta'); ?>
  <meta name="description" content="<?php echo e($sitesetting->meta_desc); ?>" />
  <meta name="keywords" content="<?php echo e($sitesetting->meta_keyword); ?>" />
  <meta name="author" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="<?php echo e(url('/')); ?>" />
  <meta property="og:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta property="og:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta property="og:url" content="<?php echo e(url('/')); ?>" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="twitter:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
<?php $__env->stopSection(); ?>
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "<?php echo e($sitesetting->comp_name ?? 'Pandit Chirag Guruji'); ?>",
    "url": "<?php echo e(url('/')); ?>",
    "logo": "<?php echo e(asset($sitesetting->image ?? '')); ?>",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": <?php echo e($sitesetting->comp_phone); ?>,
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo e(strip_tags($sitesetting->comp_address ?? '')); ?>",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "<?php echo e(url('/')); ?>"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "<?php echo e(url('/')); ?>/services"
        }
      ]
    }
  }
</script>



<?php $__env->startSection('pagetitle'); ?>
  <title><?php echo e($sitesetting->comp_name); ?> | About Us</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- partial:partia/__subheader.html -->
  <div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url(<?php echo e(asset('assets/user/images/subheader.jpg')); ?>)">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>About Us</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">About Us</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>
  <!-- partial -->

  <!-- About Start -->
  <section class="section">
    <div class="container">
      <div class="raw">
        <p class="home-about-sec" style="text-align: center;"><?php echo e($education->name ?? ''); ?></p>
      </div>
      <div class="row align-items-center">
        <div class="col-lg-6 mb-lg-30">
          <div class="img-group">
            <div class="img-group-inner">
              <img class="img-fixed-1" src="<?php echo e($education->image1 ? asset($education->image1) : asset('assets/user/images/about-group1/1.jpg')); ?>" alt="about">
              <span></span>
              <span></span>
            </div>
            <img class="img-fixed-2" src="<?php echo e($education->image1 ? asset($education->image2) : asset('assets/user/images/about-group1/2.jpg')); ?>" alt="about">
            <img class="img-fixed-3" src="<?php echo e($education->image1 ? asset($education->image3) : asset('assets/user/images/about-group1/3.jpg')); ?>" alt="about">
          </div>
        </div>
        <div class="col-lg-6">
          <div class="me-lg-30">
            <div class="section-title mb-0 text-start">
              
              <h4 class="title"><?php echo e($education->title ?? ''); ?></h4>
            </div>
            <p class="bg-transparent"><?php echo $education->description ?? ''; ?></p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- About End -->

  <!-- History Start -->
  <div class="section light-bg">
    <div class="container">

      <div class="sigma_timeline">

        <div class="row g-0 justify-content-end justify-content-md-around align-items-start sigma_timeline-nodes">
          <div class="col-12 col-md-5 order-3 order-md-1 sigma_timeline-content">
            <h4>Some Important Life Lessons From Bhagwat Gita</h4>
            <p>Temple is a place where Hindu worship our Bhagwan Ram, Shiva, Vishnu, Krishna etc. Proin eget tortor industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type, People ask questions related to Hinduism.
              specimen book. </p>
          </div>
          <div class="col-2 col-sm-1 px-md-3 order-2 sigma_timeline-image text-md-center">
            <i class="far fa-circle"></i>
          </div>
          <div class="col-12 col-md-5 order-1 order-md-3 pb-3 sigma_timeline-date">
            <span>2019</span><br><span class="sigma_timeline-month">JUN 1</span>
          </div>
        </div>
        <div class="row g-0 justify-content-end justify-content-md-around align-items-start sigma_timeline-nodes">
          <div class="col-12 col-md-5 order-3 order-md-1 sigma_timeline-content">
            <h4>People ask questions related to Hinduism</h4>
            <p>People ask questions related to Hinduism. Temple is a place where Hindu worship our Bhagwan Ram, Shiva, Vishnu, Krishna etc. Proin eget tortor industry's standard dummy text ever since the 1500s, when an unknown</p>
          </div>
          <div class="col-2 col-sm-1 px-md-3 order-2 sigma_timeline-image text-md-center">
            <i class="far fa-circle"></i>
          </div>
          <div class="col-12 col-md-5 order-1 order-md-3 pb-3 sigma_timeline-date">
            <span>2020</span><br><span class="sigma_timeline-month">JUN 1</span>
          </div>
        </div>
        <div class="row g-0 justify-content-end justify-content-md-around align-items-start sigma_timeline-nodes">
          <div class="col-12 col-md-5 order-3 order-md-1 sigma_timeline-content">
            <h4>Some Important Life Lessons From Bhagwat Gita</h4>
            <p>Temple is a place where Hindu worship our Bhagwan Ram, Shiva, Vishnu, Krishna etc. Proin eget tortor industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type, People ask questions related to Hinduism.
              specimen book. </p>
          </div>
          <div class="col-2 col-sm-1 px-md-3 order-2 sigma_timeline-image text-md-center">
            <i class="far fa-circle"></i>
          </div>
          <div class="col-12 col-md-5 order-1 order-md-3 pb-3 sigma_timeline-date">
            <span>2024</span><br><span class="sigma_timeline-month">JUN 1</span>
          </div>
        </div>
        <div class="row g-0 justify-content-end justify-content-md-around align-items-start sigma_timeline-nodes">
          <div class="col-12 col-md-5 order-3 order-md-1 sigma_timeline-content">
            <h4>People ask questions related to Hinduism</h4>
            <p>People ask questions related to Hinduism. Temple is a place where Hindu worship our Bhagwan Ram, Shiva, Vishnu, Krishna etc. Proin eget tortor industry's standard dummy text ever since the 1500s, when an unknown</p>
          </div>
          <div class="col-2 col-sm-1 px-md-3 order-2 sigma_timeline-image text-md-center">
            <i class="far fa-circle"></i>
          </div>
          <div class="col-12 col-md-5 order-1 order-md-3 pb-3 sigma_timeline-date">
            <span>2024</span><br><span class="sigma_timeline-month">JUN 1</span>
          </div>
        </div>

      </div>

    </div>
  </div>
  <!-- History End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.subapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/panditchiragguru/public_html/resources/views/user/aboutus.blade.php ENDPATH**/ ?>