<?php $__env->startSection('title', $service->meta_title ?? $service->title); ?>

<?php
    $seo = [
        'title' => $service->meta_title ?? $service->title . ' | Extrutech Hardware',
        'description' => $service->meta_description ?? Str::limit(strip_tags($service->short_description), 160),
        'keywords' => $service->meta_keywords ?? 'aluminium hardware, glass hardware, ' . $service->title,
        'image' => asset('assets/user/img/extrutech.png'),
        'author' => 'Extrutech Hardware',
        'robots' => 'INDEX,FOLLOW',
        'canonical' => url('/')
    ];
?>

<?php $__env->startSection('meta'); ?>
<meta property="og:type" content="website">
<meta property="og:title" content="<?php echo e($seo['title']); ?>">
<meta property="og:description" content="<?php echo e($seo['description']); ?>">
<meta property="og:image" content="<?php echo e($seo['image']); ?>">
<meta property="og:url" content="<?php echo e($seo['canonical']); ?>">
<meta property="og:site_name" content="Extrutech Hardware">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo e($seo['title']); ?>">
<meta name="twitter:description" content="<?php echo e($seo['description']); ?>">
<meta name="twitter:image" content="<?php echo e($seo['image']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('schema'); ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "name": "<?php echo e($service->name); ?>",
  "description": "<?php echo e(strip_tags(Str::limit($service->description, 160))); ?>",
  "image": "<?php echo e(asset($service->image)); ?>",
  "provider": {
    "@type": "Organization",
    "name": "Extrutech Hardware",
    "url": "<?php echo e(url('/')); ?>"
  },
  "url": "<?php echo e(url()->current()); ?>"
}
</script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="breadcumb-area" itemscope itemtype="https://schema.org/BreadcrumbList">
        <div class="breadcumb-wrapper" data-bg-src="<?php echo e(asset('assets/user/img/bg/breadcumb-bg.jpg')); ?>">
            <div class="container">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title text-anime" itemprop="name"><?php echo e($service->name ?? 'Service Detail'); ?></h1>
                    <ul class="breadcumb-menu">
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <a href="<?php echo e(url('/')); ?>" itemprop="item"><span itemprop="name">Home</span></a>
                            <meta itemprop="position" content="1" />
                        </li>
                        <li itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <span itemprop="name">Service Detail</span>
                            <meta itemprop="position" content="2" />
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <section class="space overflow-hidden">
        <div class="container">

            <div class="page-img space-bottom">
                <img src="<?php echo e(asset($service->image)); ?>"
                    alt="<?php echo e($service->name); ?>"
                    title="<?php echo e($service->name); ?>">
            </div>

            <div class="row gy-4">
                <div class="col-xl-12">
                    <div class="page-content">
                        <h1 class="mb-3"><?php echo e($service->name); ?></h1>
                        <div class="fs-18 mb-50"><?php echo $service->description; ?></div>
                    </div>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layout.sub-app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/extrutechhardwar/public_html/development.extrutechhardware.com/resources/views/user/servicedetail.blade.php ENDPATH**/ ?>